/******************************************************************
  
  Module:  rulepacket.cpp
  
  Author: Sean Craig
  
  Copyright 2005 Sony Online Entertainment.  All rights reserved.
  
*******************************************************************/

//-------------------------------------------------------- Includes
#include "rulepacket.h"
#include "calculation.h"
#include "rule.h"
//---------------------------------------------- Class Declarations
//--------------------------------------------------------- Globals
//----------------------------------------- Functions Declarations
//------------------------------------ Member Functions Definitions

//------------------------------------ cRulePacket

//------------------------------------ cFlagPacket

void          
cFlagPacket::SetFlag(const char *name)
{
  mFlagID = SyHashResourceID(name);
};

bool          
cFlagPacket::IsFlag(const char *name)
{
  return (mFlagID == SyHashResourceID(name));
}
//------------------------------------ cCalcPacket

void      
cCalcPacket::AddTotal(int bonus,const char *description, const char *modifier) // strings for reporting
{
  mTotal += bonus;
  Log("+%d=%d\t%s(%s)\n",bonus,mTotal,description,modifier);

}

void      
cCalcPacket::MultiplyTotal(float multiplier,const char *description, const char *modifier) // strings for reporting
{
  mTotal =(int) ((float)mTotal * multiplier);
  Log("*%.4f=%d\t%s(%s)\n",multiplier,mTotal,description,modifier);
}

void      
cCalcPacket::SetTotal(int newtotal,const char *description, const char *modifier) // strings for reporting
{
  mTotal = newtotal;
  Log("=%d\t%s(%s)\n",mTotal,description,modifier);
}

//------------------------------------ cHitPacket


//------------------------------------ cDamagePacket

cDamagePacket::cDamagePacket() :
  mNormalType(NDT_BLUNT),
  mMagicType(MDT_NONE)
{
  mClass = CLASS_DAMAGE;
}

cDamagePacket::~cDamagePacket()
{
}

// EOF
