/******************************************************************
  
  Module:  script_pawn.h
  
  Author: Sean Craig
  
  Description: Titan specific code for interfacing with the Pawn 
  scripting language

  
  Copyright 2005 Sony Online Entertainment.  All rights reserved.
  
*******************************************************************/

#ifndef SCRIPT_PAWN_H
#define SCRIPT_PAWN_H

//-------------------------------------------------------- Includes
#include "gameobj.h"
#include "Titan.h"
//-------------------------------------------------------- Typedefs
//---------------------------------------------- Class Declarations

typedef enum
{
  PET_ACTIVATE,  // Character activates an object

  PET_TRIGGER_ENTER,     // Character enters a trigger zone
  PET_TRIGGER_EXIT,      // Character exits a trigger zone

  PET_STARTUP,   // on level load
  PET_COLLIDE,   // Character collides with an object
  PET_HIT,
  PET_DEATH,
  PET_INIT,
  NUM_EVENT_TYPES

} ePawnEventType;

typedef unsigned int tScriptInstanceID; 

static const tScriptInstanceID ID_COMPLETED = 0;

class cScriptInstance;
struct tagAMX;
typedef tagAMX AMX;


class cScriptSys
{
public:
  cScriptSys(Titan *titan);
  ~cScriptSys();

  void      Clear();
  bool      LoadScript(const char *filename); // currently only one loaded script at a time...

  void      ScriptEvent(ePawnEventType type, tGameObjectID actor, tGameObjectID target);
  bool      ScriptQuery(ePawnEventType type, tGameObjectID actor, tGameObjectID target,int *result);

  void      Update(float time); // resumes waiting scripts...

  void      NotifyDestinationReached(tGameObjectID actor); // notify script that an actor has reached his destination.
  void      NotifyAnimationCompleted(tGameObjectID actor);

  bool      Recompile(); // recompiles current script
  bool      Compile(const char *filename); // recompile named script.

  void      AddClone(cScriptInstance *instance);
  Titan *   GetTitan(){return mpTitan;};

  void      EnableDebugging();
  void      DebugCallback(AMX *amx);
  void      DebugRestore();

  void      Startup(); // call startup script next update
  void      DebugPrint(const char *output);
protected:
  friend class cScriptInstance;

  cScriptInstance *GetActive(){return mActive;};
  void      DisableDebugging();
  bool      LoadSourceFile(const char *filename);

  cScriptInstance *               mSource; // source pawn script (gets cloned)
  cScriptInstance *               mActive; // active pawn script
  SyVector<cScriptInstance *>     mClones; // clones of active pawn script (because of wait conditions)
  Titan  *                        mpTitan;
  char *                          mFilename; // so i knows what to recompile
  bool                            mbDebugging; // true if we're debugging
  char *                          mSourceFile; // if debugging
  char *                          mSourceFilename;
  int                             mLastLinenum;
  bool                            mbRun; // skips stepthrough until next time.
  bool                            mbStartup; // need to run the startup script
  SyString                        mDebugOutput;
};
//------------------------------------------- Function Declarations
tGameObjectID Script_GetThisID(AMX *amx);
tGameObjectID Script_GetOtherID(AMX *amx);
Titan *       Script_GetTitan(AMX *amx);
void          Script_SetWaitTime(AMX *amx,int time_msecs);
//--------------------------------------------------------- Globals
//------------------------------------------------ Inline Functions

#endif
