/********************************************************************

  Module: TiEquipWindow

  Author: Carlo Ordonez

  Description:

    Equippable item window

  Copyright 2005 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#ifndef _TiEquipWindow_h_
#define _TiEquipWindow_h_

#include "TiWindow.h"
#include "TiWindowEvent.h"
#include "TiItemEvent.h"
#include <list>

using namespace std;

#define ID_TITAN_EQUIP    (wxID_HIGHEST + 0x0800)

class TitanI;
class TiItemDescription;
class TiItemWindow;

class TiEquipWindow : public TiWindow
{
public:
  TiEquipWindow( wxWindow* pParent, TitanI* pTitan, int PlayerId, const wxString& Name = _("EquipWindow"), int WindowId = ID_TITAN_EQUIP );
  ~TiEquipWindow();

private:

  enum EquipSlot  // see eEquipSlot
  {
    kMelee,
    kRanged,
    kHead,
    kBody,
    kFeet,
    kAccessory,

    kMax
  };

  class Slot
  {
  public:
    Slot( const wxString& Name, const wxString& Image, EquipSlot EquipSlot );

    int GetHeight() const;
    int GetWidth() const;

    void Draw( wxDC* pDC, wxPoint Location, bool Selected );

  public:
    wxString  mName;
    wxString  mImage;
    EquipSlot mEquipSlot;
  };

private:

  void        OnKeyDown( wxKeyEvent& event );
  void        OnPaint( wxPaintEvent& event );
  void        ItemList_Close( TiWindowEvent& event );
  void        ItemList_Activate( TiItemEvent& event );
  void        ItemList_Drop( TiItemEvent& event );

  void        Next();
  void        Prev();
  void        Select();
  void        CloseItemList();

  int         GetEquippedItem( EquipSlot Slot );  // returns item handle

private:

  list< Slot >        mSlots;
  int                 mSelection;
  TiItemDescription*  mpDescription;
  TiItemWindow*       mpItemWindow;

  DECLARE_CLASS( TiEquipWindow )
  DECLARE_EVENT_TABLE()
};

#endif

