/********************************************************************

  Module: TiInventoryWindow

  Author: Carlo Ordonez

  Description:

    Inventory window (all items)

  Copyright 2005 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#ifndef _TiInventoryWindow_h_
#define _TiInventoryWindow_h_

#include "TiWindow.h"

#define ID_TITAN_INVENTORY        (wxID_HIGHEST + 0x0900)
#define ID_TITAN_INVENTORY_LIST   (ID_TITAN_INVENTORY + 0x01)
#define ID_TITAN_INVENTORY_DESC   (ID_TITAN_INVENTORY + 0x02)

class TitanI;
class TiListView;
class wxTextCtrl;

class TiInventoryWindow : public TiWindow
{
public:
  TiInventoryWindow( wxWindow* pParent, TitanI* pTitan, int PlayerId, const wxString& Name = _("InventoryWindow"), int WindowId = ID_TITAN_INVENTORY );
  ~TiInventoryWindow();

private:

  void          OnKeyDown( wxKeyEvent& event );
  void          OnPaint( wxPaintEvent& event );
  void          OnSetFocus( wxFocusEvent& event );
  void          OnSize( wxSizeEvent& event );

  TiListView*   mpListView;
  wxTextCtrl*   mpDescription;

  DECLARE_CLASS( TiInventoryWindow )
  DECLARE_EVENT_TABLE()
};

#endif

