/********************************************************************

  Module: TiItemDescription

  Author: Carlo Ordonez

  Description:

    Window for item descriptions

  Copyright 2005 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#include "TiItemDescription.h"
#include "TitanI.h"

IMPLEMENT_CLASS( TiItemDescription, TiWindow )

BEGIN_EVENT_TABLE( TiItemDescription, TiWindow )
EVT_PAINT( TiItemDescription::OnPaint )
END_EVENT_TABLE()

//***********************************************************************
// Constructor
//***********************************************************************

TiItemDescription::TiItemDescription( wxWindow* pParent, TitanI* pTitan, int PlayerId, const wxString& Name, int WindowId )
: TiWindow( pParent, pTitan, PlayerId, Name, WindowId )
{
  // create controls
  wxBoxSizer* sizer = new wxBoxSizer(wxVERTICAL);
  this->SetSizer(sizer);

  int growFactor = 0;
  int border = 5;

  mpTitle = new wxStaticText( this, wxID_STATIC, _("Current Item"), wxDefaultPosition, wxDefaultSize, wxALIGN_CENTRE|wxSTATIC_BORDER );
  sizer->Add( mpTitle, growFactor, wxGROW|wxTOP|wxLEFT|wxRIGHT|wxADJUST_MINSIZE, border);
  mpTitle->GetFont().SetUnderlined( true );
  mpTitle->GetFont().SetWeight( wxBOLD );

  mpName = new wxStaticText( this, wxID_STATIC, _(""), wxDefaultPosition, wxDefaultSize, wxALIGN_CENTRE|wxSTATIC_BORDER );
  sizer->Add(mpName, growFactor, wxGROW|wxLEFT|wxRIGHT|wxADJUST_MINSIZE, border);
  mpName->GetFont().SetWeight( wxBOLD );

  mpQuantity = new wxStaticText( this, wxID_STATIC, _(""), wxDefaultPosition, wxDefaultSize, wxALIGN_CENTRE|wxSTATIC_BORDER );
  sizer->Add(mpQuantity, growFactor, wxGROW|wxLEFT|wxRIGHT|wxADJUST_MINSIZE, border);

  mpValue = new wxStaticText( this, wxID_STATIC, _(""), wxDefaultPosition, wxDefaultSize, wxALIGN_CENTRE|wxSTATIC_BORDER );
  sizer->Add(mpValue, growFactor, wxGROW|wxLEFT|wxRIGHT|wxADJUST_MINSIZE, border);

  mpBonus = new wxStaticText( this, wxID_STATIC, _(""), wxDefaultPosition, wxDefaultSize, wxALIGN_CENTRE|wxSTATIC_BORDER );
  sizer->Add(mpBonus, growFactor, wxGROW|wxLEFT|wxRIGHT|wxBOTTOM|wxADJUST_MINSIZE, border);

  // sizers, do your thing
  GetSizer()->SetSizeHints( this );
  Layout();
  Center();
}

//***********************************************************************
// Destructor
//***********************************************************************

TiItemDescription::~TiItemDescription()
{
  mpTitle->Destroy();
  mpName->Destroy();
  mpQuantity->Destroy();
  mpValue->Destroy();
  mpBonus->Destroy();
}

//***********************************************************************
// SetTitle
//***********************************************************************

void TiItemDescription::SetTitle( const wxString& Title )
{
  mpTitle->SetLabel( Title );
}

//***********************************************************************
// OnPaint
//***********************************************************************

void TiItemDescription::OnPaint( wxPaintEvent& event )
{
  TiWindow::OnPaint( event );
  wxPaintDC dc( this );

  wxString name, qty, value, bonus;

  // set text
  if( mItemHandle >= 0 && mItemHandle < mpTitan->InventoryGetItemCount( mPlayerId ) )
  {
    // todo: get this from t4
    name = mpTitan->InventoryGetItemName( mPlayerId, mItemHandle );
    qty = wxString::Format("Qty: %d", mpTitan->InventoryGetItemQuantity(mPlayerId,mItemHandle));
    value = wxString::Format("Value: %d", mpTitan->InventoryGetItemValue(mPlayerId,mItemHandle));
    bonus = wxString::Format("Bonus: %d", mpTitan->InventoryGetItemDamageBonus(mPlayerId,mItemHandle));
  }

  mpName->SetLabel( name );
  mpQuantity->SetLabel( qty );
  mpValue->SetLabel( value );
  mpBonus->SetLabel( bonus );
  GetSizer()->Fit( this );
  Layout();
}

