/********************************************************************

  Module: TiItemWindow

  Author: Carlo Ordonez

  Description:

    List of items

  Copyright 2005 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#ifndef _TiItemWindow_h_
#define _TiItemWindow_h_

#include "TiWindow.h"
#include "TiItemEvent.h"

#define ID_TITAN_ITEM_LIST        (wxID_HIGHEST + 0x0a00)
#define ID_TITAN_ITEM_LIST_VIEW   (ID_TITAN_ITEM_LIST + 0x01)

class TitanI;
class TiListView;
class TiItemDescription;

class TiItemWindow : public TiWindow
{
public:
  TiItemWindow( wxWindow* pParent, TitanI* pTitan, int PlayerId, const wxString& Name = _("ItemWindow"), int WindowId = ID_TITAN_ITEM_LIST );
  ~TiItemWindow();

  void          SetItemType( int Type ) { mType = Type; }
  int           GetItemType() const { return( mType ); }

  void          OnDrop( TiItemEvent& event );

private:

  void          OnPaint( wxPaintEvent& event );
  void          OnKeyDown( wxKeyEvent& event );
  void          OnSetFocus( wxFocusEvent& event );

  void          Select();
  void          Drop();

private:

  int                 mType;
  TiListView*         mpListView;
  TiItemDescription*  mpDescription;

  DECLARE_CLASS( TiItemWindow )
  DECLARE_EVENT_TABLE()
};

#endif

