/********************************************************************

  Module: TiListView

  Author: Carlo Ordonez

  Description:

    Titan list view base class

  Copyright 2005 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#include "TiListView.h"

IMPLEMENT_CLASS( TiListView, wxListView )

BEGIN_EVENT_TABLE( TiListView, wxListView )
END_EVENT_TABLE()

//***********************************************************************
// Constructor
//***********************************************************************

TiListView::TiListView( wxWindow* pParent, int WindowId, long Style )
: wxListView( pParent, WindowId, wxDefaultPosition, wxDefaultSize, Style )
{
}

//***********************************************************************
// Next
//***********************************************************************

void TiListView::Next()
{
  long sel = GetFirstSelected();
  if( sel >= 0 && sel+1 < GetItemCount() )
  {
    Select( sel+1 );
  }
}

//***********************************************************************
// Prev
//***********************************************************************

void TiListView::Prev()
{
  long sel = GetFirstSelected();
  if( sel > 0 && GetItemCount() > 1 )
  {
    Select( sel-1 );
  }
}
