/********************************************************************

  Module: TiWindow

  Author: Carlo Ordonez

  Description:

    Titan window base class.

  Copyright 2005 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#include "TiWindow.h"
#include "TitanI.h"

IMPLEMENT_ABSTRACT_CLASS( TiWindow, wxWindow )

BEGIN_EVENT_TABLE( TiWindow, wxWindow )
EVT_PAINT( TiWindow::OnPaint )
END_EVENT_TABLE()

//***********************************************************************
// Constructor
//***********************************************************************

TiWindow::TiWindow( wxWindow* pParent, TitanI* pTitan, int PlayerId, const wxString& Name, int WindowId )
: wxWindow( pParent, WindowId, wxDefaultPosition, wxDefaultSize, 0, Name )
{
  mpTitan = pTitan;
  mPlayerId = PlayerId;
  mFade = 0.0f;
  mFadeDir = 1;
}

//***********************************************************************
// Process
//***********************************************************************

#define MIN(X, Y) ( (X) > (Y) ? Y : X )
#define MAX(X, Y) ( (X) > (Y) ? X : Y )

void TiWindow::Process()
{
  // update fade
  if( mFadeDir > 0 )
  {
    mFade = MIN( 1.f, mFade + .15f );
  }
  else
  {
    mFade = MAX( 0.f, mFade - .2f );
  }

  //  if( mFade > 0.f && mFade < 1.f )
  //  {
  //    SyDebug( "fade=%f\n", mFade );
  //  }

  if( IsOpening() || IsOpen() )
  {
    this->Show( true );
  }
  else if( IsClosed() )
  {
    this->Show( false );
  }

  OnProcess();
}

//***********************************************************************
// IsOpening
//***********************************************************************

bool TiWindow::IsOpening() const
{
  if( mFade < 1.f && mFadeDir == 1 )
  {
    return( true );
  }
  return( false );
}

//***********************************************************************
// IsOpen
//***********************************************************************

bool TiWindow::IsOpen() const
{
  if( mFade == 1.f )
  {
    return( true );
  }
  return( false );
}

//***********************************************************************
// Open
//***********************************************************************

void TiWindow::Open( bool Instant /*= false*/ )
{
  if( Instant )
  {
    mFade = 1.0f;
  }

  mFadeDir = 1;
}

//***********************************************************************
// IsClosing
//***********************************************************************

bool TiWindow::IsClosing() const
{
  if( mFade > 0.f && mFadeDir == -1 )
  {
    return( true );
  }
  return( false );
}

//***********************************************************************
// IsClosed
//***********************************************************************

bool TiWindow::IsClosed() const
{
  if( mFade == 0.f )
  {
    return( true );
  }
  return( false );
}

//***********************************************************************
// Close
//***********************************************************************

void TiWindow::Close( bool Instant /*= false*/ )
{
  if( Instant )
  {
    mFade = 0.0f;
  }
  mFadeDir = -1;
}

//***********************************************************************
// DrawSizer
// FOR DEBUGGING
//***********************************************************************

void TiWindow::DrawSizer( wxSizer* pSizer, wxPaintDC& DC )
{
  if( pSizer )
  {
    wxPoint pt = pSizer->GetPosition();
    wxSize size = pSizer->GetSize();
    DC.SetPen( *wxGREEN_PEN );
    DC.DrawRectangle( pt, size );

    // draw children
    wxSizerItemList& children = pSizer->GetChildren();
    wxSizerItemList::compatibility_iterator it = children.GetFirst();
    while(it)
    {
      wxSizerItem* item = it->GetData();
      if( item->IsSizer() )
      {
        DrawSizer( item->GetSizer(), DC );
      }

      it = it->GetNext();
    }
  }
}

//***********************************************************************
// OnPaint
//***********************************************************************

void TiWindow::OnPaint( wxPaintEvent& event )
{
  wxPaintDC dc( this );

  PrepareDC( dc );
  dc.BeginDrawing();
  {
    // black border
    dc.SetPen( *wxBLACK_PEN );
    dc.SetBrush( *wxTRANSPARENT_BRUSH );
    dc.DrawRectangle( GetClientRect() );

    // FOR DEBUGGING
    //DrawSizer( GetSizer(), dc );
  }
  dc.EndDrawing();
}

//***********************************************************************
// OnKeyDown
//***********************************************************************

void TiWindow::OnKeyDown( wxKeyEvent& event )
{
  event.Skip();
}

