/********************************************************************

  Module: TiWindow

  Author: Carlo Ordonez

  Description:

    Titan window base class.

  Copyright 2005 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#ifndef _TiWindow_h_
#define _TiWindow_h_

#include "wx/wx.h"

class TitanI;
class TiWindow : public wxWindow
{
public:
  TiWindow( wxWindow* pParent, TitanI* pTitan, int PlayerId, const wxString& Name = _("TiWindow"), int WindowId = -1 );
  virtual ~TiWindow() {}

  void            Process();

  bool            IsOpening() const;
  bool            IsOpen() const;
  void            Open( bool Instant = false );

  bool            IsClosing() const;
  bool            IsClosed() const;
  void            Close( bool Instant = false );

  float           Opacity() const { return( mFade ); }

protected:

  virtual void    OnPaint( wxPaintEvent& event );
  virtual void    OnKeyDown( wxKeyEvent& event );
  virtual void    OnProcess() {}

private:

  void            DrawSizer( wxSizer* pSizer, wxPaintDC& DC );

protected:

  TitanI*         mpTitan;
  int             mPlayerId;
  float           mFade;
  int             mFadeDir;

  DECLARE_ABSTRACT_CLASS( TiWindow )
  DECLARE_EVENT_TABLE()
};

#endif

