// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif

#include "wx/joystick.h"

#include "./TitanController.h"
#include "./TitanUI.h"

TitanController::TitanController( int deviceId )
{
  mpJoystick = new wxJoystick(deviceId);
}

TitanController::~TitanController()
{
  mpJoystick->ReleaseCapture();
  delete mpJoystick;
}

// returns true if the controller is connected.
bool TitanController::GetConnected() const
{
  return mpJoystick->IsOk();
}

// returns true if the specified button is depressed.
bool TitanController::GetButtonState( TitanButton tb ) const
{
  int index = TitanUI::GetButtonIndex( tb );
  if ( index == -1 )
  {
    return false;
  }
  return ( mpJoystick->GetButtonState() & (1<<index)) != 0;
}

// returns a value in the range [-10000,+10000] that indicates whether
// the directional control is pushed completely forward (+10000),
// int backward (-10000) or somewhere in between.
int TitanController::GetForward() const
{
  return -1 * mpJoystick->GetPosition().y;
}

// returns a value in the range [-10000,+10000] that indicates whether
// the right directional control is pushed completely to the right (+10000),
// completely to the left (-10000) or somewhere in between.
int TitanController::GetRight() const
{
  return mpJoystick->GetPosition().x;
}

// returns a value in the range [-10000,+10000] that indicates whether
// the directional control is pushed completely forward (+10000),
// int backward (-10000) or somewhere in between.
int TitanController::GetRightStickForward() const
{
  return -1 * mpJoystick->GetRudderPosition();
}

// returns a value in the range [-10000,+10000] that indicates whether
// the right directional control is pushed completely to the right (+10000),
// completely to the left (-10000) or somewhere in between.
int TitanController::GetRightStickRight() const
{
  return mpJoystick->GetZPosition();
}

void TitanController::SetCapture( wxWindow* window )
{
  mpJoystick->SetCapture( window );
}
