/********************************************************************

  Module: TitanHUD

  Author: Carlo Ordonez

  Description:

    Displays name, power bars

  Copyright 2005 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#ifndef _TitanHUD_h_
#define _TitanHUD_h_

#include "wx/wx.h"

#define ID_TITANFRAME_HUD     (wxID_HIGHEST + 0x0100)
#define ID_TITANHUD_NAME      (ID_TITANFRAME_HUD + 0x01)
#define ID_TITANHUD_HEALTH    (ID_TITANFRAME_HUD + 0x02)
#define ID_TITANHUD_BLOCK     (ID_TITANFRAME_HUD + 0x03)

class TitanHUD : public wxWindow
{
public:

  TitanHUD( wxFrame* pFrame, wxWindowID Id, const wxPoint& Position );
  ~TitanHUD();

  void    SetPlayerName( const wxString& Name );

  void    SetHealth( int Health );
  void    SetHealthMax( int HealthMax );

  void    SetBlock( int Block );
  void    SetBlockMax( int BlockMax );

private:

  wxStaticText*   mpName;
  wxGauge*        mpHealth;
  wxGauge*        mpBlock;
};

#endif
