#include ".\TitanUI.h"

// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif

#include "wx/virtual/vwnd.h"
#include "wx/virtual/vdesktop.h"
#include "PawnDebug.h"
#include "PawnOutput.h"

TitanUI::TitanUI( wxWindow* window ) :
mpWxWindow( window ),
mpPawnOutput(NULL)
{
  GetController(0); // force a controller create

  #if (defined(_DEBUG) && !defined(SN_TARGET_PS3))
  mpPawnOutput = new PawnOutput(window);
  mpWxWindow->SetFocus();
  #endif 
}

TitanUI::~TitanUI()
{
  std::map<int,TitanController*>::iterator i = mControllers.begin();
  while ( i != mControllers.end() )
  {
    delete i->second;
    i++;
  }
  mControllers.clear();
}

// Get a pointer to an interface that can be used to poll a controller state
TitanControllerI* TitanUI::GetController( int controllerId )
{
  std::map<int,TitanController*>::iterator i = mControllers.find(controllerId);
  if ( i == mControllers.end() )
  {
    TitanController* controller = new TitanController(controllerId);
    controller->SetCapture( mpWxWindow );
    mControllers[controllerId] = controller;
    return controller;
  }
  return i->second;
}

// Get the scene titan can use for drawing
SyScene* TitanUI::GetScene()
{
  return (SyScene*)VDesktop::Get()->GetScene();
}

// Get the scene titan can use for drawing
SyPerformanceStats* TitanUI::GetPerformanceStats()
{
  return (SyPerformanceStats*)VDesktop::Get()->GetPerformanceStats();
}

// Use this method instead of Scene::Clear to give the interface an 
// opportunity to reload its assets after the clear. 
int TitanUI::ClearScene()
{
  return VDesktop::Get()->ClearScene();
}


struct ButtonMap
{
  int         mButtonIndex;
  TitanButton mTitanButton;
};

ButtonMap gTitanPS2ButtonMap[] =
{
  { 6, ButtonAttackL },
  { 7, ButtonAttackS },
  { 5, ButtonJump },
  { 9, ButtonAction },
  { 4, ButtonAttackRanged },
  { 10, ButtonBlock },
  { 8, ButtonMagic },
  { 11, ButtonDodge },
  { 15, ButtonToggleAutomap },
  { 12, ButtonPause},
  { -1,ButtonMax} // terminator
};        

ButtonMap gTitanAirFloButtonMap[] =
{
  { 4, ButtonAttackL },
  { 6, ButtonAttackS },
  { 5, ButtonJump },
  { 11, ButtonAction },
  { 7, ButtonAttackRanged },
  { 8, ButtonBlock },
  { 10, ButtonMagic },
  { 9, ButtonDodge },
  { 15, ButtonToggleAutomap },
  { 12, ButtonPause},
  { -1,ButtonMax} // terminator
};

ButtonMap gTitanLogitechButtonMap[] =
{
#ifdef __CELLOS_LV2__
  { 4,  ButtonAttackL },
  { 6,  ButtonAttackS },
  { 5,  ButtonJump },
  { 11, ButtonAction },
  { 7,  ButtonAttackRanged },
  { 8,  ButtonBlock },
  { 9,  ButtonMagic },
  { 10, ButtonDodge },
  { 14, ButtonToggleAutomap },
  { 13, ButtonPause},
  { -1, ButtonMax} // terminator
#else
  { 5,  ButtonAttackL },
  { 4,  ButtonAttackS },
  { 6,  ButtonJump },
  { 11, ButtonAction },
  { 7,  ButtonAttackRanged },
  { 8,  ButtonBlock },
  { 10, ButtonMagic },
  { 9,  ButtonDodge },
  { 14, ButtonToggleAutomap },
  { 12, ButtonPause },
  { -1, ButtonMax } // terminator
#endif
};

ButtonMap *gCurrentTitanButtonMap = gTitanAirFloButtonMap;

void        
TitanUI::SetControllerMapping(eControllerMapping mapping)
{
  switch (mapping)
  {
  case CONTROLLER_MAPPING_AIRFLO:
    gCurrentTitanButtonMap = gTitanAirFloButtonMap;
    break;
  case CONTROLLER_MAPPING_PS2:
    gCurrentTitanButtonMap = gTitanPS2ButtonMap;
    break;
  case CONTROLLER_MAPPING_LOGITECH:
    gCurrentTitanButtonMap = gTitanLogitechButtonMap;
    break;
  default:
    // unknown mapping SyAssertf(0,"Unknown Mapping");
    break;
  }
}

TitanButton TitanUI::GetTitanButton( int buttonIndex )
{
  for ( int i = 0; gCurrentTitanButtonMap[i].mButtonIndex!=-1;i++ )
  {
    if ( gCurrentTitanButtonMap[i].mButtonIndex == buttonIndex )
    {
      return gCurrentTitanButtonMap[i].mTitanButton;
    }
  }
  return ButtonMax;
}

int TitanUI::GetButtonIndex( TitanButton titanButton )
{
  for ( int i = 0; gCurrentTitanButtonMap[i].mButtonIndex!=-1;i++ )
  {
    if ( gCurrentTitanButtonMap[i].mTitanButton == titanButton )
    {
      return gCurrentTitanButtonMap[i].mButtonIndex;
    }
  }
  return -1;
}

int 
TitanUI::PawnDebugUI(const char *src, int linenum, const char *variables)
{
  mpWxWindow->SetFocus();
  PawnDebug pd(mpWxWindow);
  pd.SetSource(wxT(src),linenum);
  pd.SetVariables(wxT(variables));
  pd.ShowModal();

  mpWxWindow->SetFocus();
  

  return (int)pd.GetResult();
}


void
TitanUI::PawnDebugShowOutput(bool show)
{
#if (defined(_DEBUG) && !defined(SN_TARGET_PS3))
  mpPawnOutput->Show(show);
  mpWxWindow->SetFocus();
#endif
}

void
TitanUI::PawnDebugOutput(const char *output)
{
#if (defined(_DEBUG) && !defined(SN_TARGET_PS3))
  mpPawnOutput->Output(output);
#endif
}


