
/******************************************************************
  
  Module:  TitanFXScriptDriver.h
  
  Author: Bijan Forutanpour
  
  Description: Application specific hooks into the FXScript system.

  
  Copyright 2005 Sony Online Entertainment.  All rights reserved.
  
*******************************************************************/
#ifndef TITANFXSCRIPTDRIVER_H
#define TITANFXSCRIPTDRIVER_H

#include "SyFXScriptSystem.h"
#include "Titan.h"
#include "animcontroller.h"
#include "physics.h"


class TitanFXScriptDriver : public SyFXScriptDefaultDriver
{
 public:
 
    TitanFXScriptDriver(Titan *titan);
    ~TitanFXScriptDriver();

		// Actor animation
    int32 PlayAnimByHandle( SyActorHandle ActorHandle, int32 AnimHandle );
    void  PlayAnimByHandleComplete(  SyActorHandle ActorHandle );

    // Camera Animation
    int  SetCamera ( const SyVect3& Loc, const SyVect3& Dir, const float32& Fov );
    int  PlayCameraAnimComplete ();

		// General Cut Scene controls
    void BeginCutScene();
    void EndCutScene();
    bool isCutScenePlaying();
    
 protected:
    Titan*      mTitan;

 private:
    bool                  mCutSceneRunning;  
    SyList <cAnimCharControllerInput*> mAnimControllers;
};
  
 
#endif
