/******************************************************************
  
  Module:  ai.h
  
  Author: Sean Craig
  
  Description:  Goals for enemy ai, implemented as a priority queue

  
  Copyright 2005 Sony Online Entertainment.  All rights reserved.
  
*******************************************************************/

#ifndef AI_H
#define AI_H

//-------------------------------------------------------- Includes
#include "gameobj.h"
//-------------------------------------------------------- Typedefs
//---------------------------------------------- Class Declarations


class cAiInterface
{
public:
  virtual ~cAiInterface();

  virtual void            Update(float time)=0;
  virtual cGameObject *   GetOwner()=0;


  virtual void            AttackTarget(int priority)=0;
  virtual void            GoTo(int priority,const SyVect3 &destination)=0;
  virtual void            FadeAway(int priority)=0;  // maybe BurnOut would be better?
  virtual void            Stand(int priority)=0;  
  virtual void            Flee(int priority, tGameObjectID targetID, float time = 0.0f, float goalDistance = 5.0f)=0;  
  virtual void            Flee(int priority, const SyVect3& pos, float time = 0.0f, float goalDistance = 5.0f)=0; 
  virtual void            Wander(int priority, float time = 0.0f)=0;  
  virtual void            Follow(int priority, tGameObjectID targetID)=0;  
  virtual void            Defend(int priority, tGameObjectID targetID)=0;  
  virtual void            Hunt(int priority, tGameObjectID targetID, const SyVect3& startLoc)=0; 
  virtual void            PatrolAddWaypoint(const SyVect3& markerLoc, float speed, float pauseTime)=0; 
  virtual void            PatrolClearWaypoints()=0; 
  virtual void            PatrolSetLooping(bool bLoop)=0; 

  virtual void            Reset() = 0;

  virtual void            SetAttackTarget(tGameObjectID target)=0;
  virtual cGameObject*    GetAttackTarget()=0;
  virtual bool            CanSeeAttackTarget()=0;
  virtual bool            GetLastSeenAttackTargetPos(SyVect3& pos)=0;

  virtual void            SetDefendTarget(tGameObjectID target)=0;
  virtual cGameObject*    GetDefendTarget()=0;
  virtual bool            CanSeeDefendTarget()=0;
  virtual bool            GetLastSeenDefendTargetPos(SyVect3& pos)=0;

  virtual void            OnAttacked(tGameObjectID attacker,int damage)=0;

  static cAiInterface *Allocate(cGameObject *owner);
  static void         RegisterTuningVariables();
  static void         DisableAll(bool bDisable);

protected:
  static bool sbDisabled;

  cAiInterface(); // call the static function Allocate instead;
};



//------------------------------------------- Function Declarations
//--------------------------------------------------------- Globals
//------------------------------------------------ Inline Functions

#endif
