/******************************************************************
  
  Module:  behaviortypes.h
  
  Author: Borut Pfeifer
  
  Description: enum for the different behaviors that an NPC can have
  
  Copyright 2005 Sony Online Entertainment.  All rights reserved.
  
*******************************************************************/

#ifndef BEHAVIORTYPES_H
#define BEHAVIORTYPES_H

//-------------------------------------------------------- Includes
//-------------------------------------------------------- Typedefs
//---------------------------------------------- Class Declarations

enum NPCBehaviorTypes
{
  NPCBEH_CLASSDEFAULT = 0,
  NPCBEH_NONE,
  NPCBEH_MELEEONLY, 
  NPCBEH_RANGEDONLY, 
  NPCBEH_MELEERANGED, 
  NPCBEH_MELEESWARM, 
  NPCBEH_MELEEFLANK, 
  NPCBEH_MELEECHARGERETREAT, 
  NPCBEH_MELEEENRAGE, 
  NPCBEH_KAMIKAZE, 
  NPCBEH_MELEESTEALTH, 
  NPCBEH_MELEESTUN, 
  NPCBEH_MELEEWANDER, 
  NPCBEH_RUNNER, 
  NPCBEH_RANGEDCIRCLE, 
  NPCBEH_RANGEDLINE, 
  NPCBEH_RANGEDSTUN,
  NPCBEH_RANGEDTELEPORT,
  NPCBEH_CAST_HEAL, 
  NPCBEH_CAST_SUMMON, 
  NPCBEH_CAST_EXPLOSION,
  NPCBEH_MAXTYPES, 
};

enum NPCFactionType
{
  NPCFACTION_CLASSDEFAULT = 0,
  NPCFACTION_MONSTER,
  NPCFACTION_NEUTRAL,
  NPCFACTION_ALLY,
  NPCFACTION_MAXTYPES,
};

// yick, I know, but this was the only way to avoid declaring this in multiple spots
// it's defined in behaviortypes.cpp
extern const char *NPC_BEHAVIOR_TYPE_NAMES[NPCBEH_MAXTYPES];


#endif
