/******************************************************************
  
  Module:  animdefs.h
  
  Author: Sean Craig
  
  Description:  Containes enum for anim id's defined in the 
  biped.ccf config file in the character tool directory

  
  Copyright 2005 Sony Online Entertainment.  All rights reserved.
  
*******************************************************************/

#ifndef ANIMDEFS_H
#define ANIMDEFS_H

//-------------------------------------------------------- Includes
//-------------------------------------------------------- Typedefs
//---------------------------------------------- Class Declarations
typedef enum 
{
  ANIM_B_STAND=2,
  ANIM_B_IDLE=2,
  ANIM_B_MOVE_F_WALK,
  ANIM_B_MOVE_F_RUN, // from Brad's mapping
  ANIM_B_DEATH = 6,
  ANIM_B_IMPACT_FRONT,
  ANIM_B_IMPACT_BACK,
  ANIM_B_IMPACT_FWD_EXTREME,
  ANIM_B_JUMP = 11,
  ANIM_B_IN_AIR,
  ANIM_B_LAND,
  ANIM_B_FALLING ,
  ANIM_B_LAND_HARD,
  ANIM_B_BLOCK,
  ANIM_B_KNOCKBACK,
  ANIM_B_KNOCKBACK_IN_AIR = 19,
  ANIM_B_KNOCKBACK_LAND,
  ANIM_B_KNOCKBACK_GETUP,

  ANIM_B_KNOCKFORWARD,
  ANIM_B_KNOCKFORWARD_IN_AIR,
  ANIM_B_KNOCKFORWARD_LAND,
  ANIM_B_KNOCKFORWARD_GETUP,

  ANIM_B_TURN_90_L =26,
  ANIM_B_TURN_90_R,
  ANIM_B_TURN_180_L,

  ANIM_B_DODGE_F,
  ANIM_B_DODGE_B,
  ANIM_B_DODGE_L,
  ANIM_B_DODGE_R,

  ANIM_B_CAST_A,
  ANIM_B_CAST_B,
  ANIM_B_CAST_C=18,
  
  ANIM_B_RUN_JUMP =35,
  ANIM_B_RUN_IN_AIR,
  ANIM_B_RUN_LAND,

  ANIM_B_BLOCK_FWD_TAKEDAM,
  ANIM_B_DODGE_FWD_TAKEDAM,

  ANIM_B_COMBAT_IDLE_01,
  ANIM_B_COMBAT_IDLE_02,
  ANIM_B_TURN_180_R,
  ANIM_B_RUN_JUMP_R,
  ANIM_B_STAND_TAKEDAM_LEFT,
  ANIM_B_STAND_TAKEDAM_RIGHT,
  ANIM_B_EMOTE_ANGER,

  ANIM_ATTACK_L = 103,
  ANIM_ATTACK_H,

  ANIM_ATTACK_LL,
  ANIM_ATTACK_LH,
  ANIM_ATTACK_HL,
  ANIM_ATTACK_HH,
  ANIM_ATTACK_LLL,
  ANIM_ATTACK_LLH,
  ANIM_ATTACK_LHL,
  ANIM_ATTACK_LHH,
  ANIM_ATTACK_HLL,
  ANIM_ATTACK_HLH,
  ANIM_ATTACK_HHL,
  ANIM_ATTACK_HHH,

  ANIM_ATTACK_JUMP,
  ANIM_RANGED_ATTACK = 200,
  ANIM_RANGED_ATTACK_JUMP,
  ANIM_OVERRIDE = 500

}  tAnimIDValues;

typedef enum __eComboType
{
  COMBO_L, 
  COMBO_H,  
  COMBO_LL,  
  COMBO_LH,   
  COMBO_HL,
  COMBO_HH,

  COMBO_LLL,  
  COMBO_LLH,
  COMBO_LHL,
  COMBO_LHH,
  COMBO_HLL,
  COMBO_HLH,
  COMBO_HHL,
  COMBO_HHH,
  NUM_COMBOS
} eComboType;


//------------------------------------------- Function Declarations
//--------------------------------------------------------- Globals
//------------------------------------------------ Inline Functions

#endif
