/******************************************************************
  
  Module:  class.cpp
  
  Author: Sean Craig
  
  Copyright 2005 Sony Online Entertainment.  All rights reserved.
  
*******************************************************************/

//-------------------------------------------------------- Includes
#include "class.h"
#include "tinyxml.h"
#include "SyAssert.h"
#include "stats.h"
#include "ai/behaviortypes.h"
#include "database.h"
//---------------------------------------------- Class Declarations

cStatistics::cStatistics() :
  mMaxHP(1.0f),
  mMaxMana(1.0f),
  mMeleePower(1.0f),
  mRangedPower(1.0f),
  mSpellPower(1.0f),
  mDefense(1.0f),
  mStrikethrough(1.0f),
  mBlockMeter(1.0f),
  mShadowResist(1.0f),
  mIceResist(1.0f),
  mFireResist(1.0f),
  mMagicResist(1.0f),
  mPoisonResist(1.0f),
  mAttackDelay(1.0f),
  mBlockDelay(1.0f),
  mMovementSpeed(1.0f),
  mCloseDistance(1.0f),
  mAccuracy(1.0f),
  mNPCBehaviorType(0),
  mNPCFaction(0)
{
}

void 
cStatistics::Parse(TiXmlNode* node)
{
  TiXmlNode* data_node;

  data_node = node->FirstChild("HP");
  if (data_node != NULL)
  {
    mMaxHP = (float)atof(data_node->FirstChild()->Value());
  }

  data_node = node->FirstChild("Mana");
  if (data_node != NULL)
  {
    mMaxMana = (float)atof(data_node->FirstChild()->Value());
  }

  data_node = node->FirstChild("MeleeAttackPower");
  if (data_node != NULL)
  {
    mMeleePower = (float)atof(data_node->FirstChild()->Value());
  }

  data_node = node->FirstChild("RangedAttackPower");
  if (data_node != NULL)
  {
    mRangedPower = (float)atof(data_node->FirstChild()->Value());
  }

  data_node = node->FirstChild("SpellPower");
  if (data_node != NULL)
  {
    mSpellPower = (float)atof(data_node->FirstChild()->Value());
  }

  data_node = node->FirstChild("Defense");
  if (data_node != NULL)
  {
    mDefense = (float)atof(data_node->FirstChild()->Value());
  }

  data_node = node->FirstChild("Strikethrough");
  if (data_node != NULL)
  {
    mStrikethrough = (float)atof(data_node->FirstChild()->Value());
  }

  data_node = node->FirstChild("BlockMeter");
  if (data_node != NULL)
  {
    mBlockMeter = (float)atof(data_node->FirstChild()->Value());
  }

  data_node = node->FirstChild("ShadowResistance");
  if (data_node != NULL)
  {
    mShadowResist = (float)atof(data_node->FirstChild()->Value());
  }

  data_node = node->FirstChild("IceResistance");
  if (data_node != NULL)
  {
    mIceResist = (float)atof(data_node->FirstChild()->Value());
  }

  data_node = node->FirstChild("FireResistance");
  if (data_node != NULL)
  {
    mFireResist = (float)atof(data_node->FirstChild()->Value());
  }

  data_node = node->FirstChild("MagicResistance");
  if (data_node != NULL)
  {
    mMagicResist = (float)atof(data_node->FirstChild()->Value());
  }

  data_node = node->FirstChild("PoisonResistance");
  if (data_node != NULL)
  {
    mPoisonResist = (float)atof(data_node->FirstChild()->Value());
  }

  data_node = node->FirstChild("AttackDelay");
  if (data_node != NULL)
  {
    //read in millisecond value and convert to seconds
    int ms = atoi(data_node->FirstChild()->Value());
    mAttackDelay = ((float)ms)*0.001f;
  }

  data_node = node->FirstChild("BlockDelay");
  if (data_node != NULL)
  {
    //read in millisecond value and convert to seconds
    int ms = atoi(data_node->FirstChild()->Value());
    mBlockDelay = ((float)ms)*0.001f;
  }

  data_node = node->FirstChild("MovementSpeed");
  if (data_node != NULL)
  {
    mMovementSpeed = (float)atof(data_node->FirstChild()->Value());
  }

  data_node = node->FirstChild("CloseDistance");
  if (data_node != NULL)
  {
    mCloseDistance = (float)atof(data_node->FirstChild()->Value());
  }

  data_node = node->FirstChild("BehaviorType");
  if (data_node != NULL)
  {
    int enumVal = 0;
    const char *type = data_node->FirstChild()->Value();
    bool result = ChooseEnum(type,NPC_BEHAVIOR_TYPE_NAMES,NPCBEH_MAXTYPES, enumVal);
    SyAssertf(result,"Unknown NPC BehaviorType type in class.xml");
    mNPCBehaviorType = (char)enumVal;
  }
  else
  {
    mNPCBehaviorType = NPCBEH_MELEEONLY;
  }

  const char *l_NPCFactionNames[] = 
  {
    "Class Default",
    "Monster",
    "Neutral", 
    "Ally",
  };

  static const int NUM_NPCFACTION_NAMES = (sizeof(l_NPCFactionNames) / sizeof (l_NPCFactionNames[0]));

  data_node = node->FirstChild("Faction");
  if (data_node != NULL)
  {
    int enumVal = 0;
    const char *type = data_node->FirstChild()->Value();
    SyAssertf(NUM_NPCFACTION_NAMES == NPCFACTION_MAXTYPES,"Forgot to add NPC Faction type name.");
    bool result = ChooseEnum(type,l_NPCFactionNames,NUM_NPCFACTION_NAMES, enumVal);
    SyAssertf(result,"Unknown Faction type in class.xml");
    mNPCFaction = (char) enumVal;
  }
  else
  {
    mNPCFaction = NPCFACTION_MONSTER;
  }
};

//----------------------------------------- Functions Declarations


cCharacterClass *
ParseClass(TiXmlNode* node)
{
  TiXmlNode* data_node;
  cCharacterClass *newmaster = new cCharacterClass; 
  data_node = node->FirstChild("Class");
  SyAssert(data_node);
  const char *name = data_node->FirstChild()->Value();
  newmaster->mName.SetName(name);

  newmaster->mStats.Parse(node);

  return newmaster;
}

cCharacterLevel *
ParseLevel(TiXmlNode* node)
{

  TiXmlNode* data_node;
  cCharacterLevel *newmaster = new cCharacterLevel; 
  data_node = node->FirstChild("Lvl");
  SyAssert(data_node);

  newmaster->mLevel = atoi(data_node->FirstChild()->Value());
  newmaster->mStats.Parse(node);

  return newmaster;
}
//------------------------------------ Member Functions Definitions


// EOF
