/******************************************************************
  
  Module:  debris.h
  
  Author: Sean Craig
  
  Description: 

    Shards and chucks generated when an object is destroyed. 
  
  Copyright 2005 Sony Online Entertainment.  All rights reserved.
  
*******************************************************************/

#ifndef DEBRIS_H
#define DEBRIS_H

//-------------------------------------------------------- Includes
#include "SyVect3.h"
#include "nameid.h"
#include "SyVector.h"
#include "SySceneTypes.h"
#include "SyMatrix44.h"
//-------------------------------------------------------- Typedefs
//---------------------------------------------- Class Declarations
class Titan;

class cDebrisShardMaster;
class cDebrisMaster;

class cDebrisShard
{
public:
  cDebrisShard(Titan *titan);
  virtual ~cDebrisShard();
  
  virtual void Init(const SyVect3 &loc, const SyVect3& start_vel, const cDebrisShardMaster &master);
  virtual void Update(float time);

protected:
  virtual void _CollisionTest(const SyVect3 &displacement);
private:
  Titan                    *mpTitan;
  SyActorHandle             mActorHandle;
  bool                      mbIsMoving;
  int                       mBounces;
  SyVect3                   mLoc;
  SyVect3                   mVelocity;
  float                     mRotSpeed;
  float                     mRotAngle;
  float                     mHeading;
  float                     mRadius;
  float                     mHeight;
};


class cDebris
{
public:
  cDebris(Titan *titan);
  ~cDebris();

  void Init(const SyVect3 &loc, const SyVect3& force,const cDebrisMaster &master);
  void Update(float time);

  bool IsDead();

private:
  Titan                    *mpTitan;
  SyVector<cDebrisShard *>   mShards;
  float                     mAge;
};


class cDebrisShardMaster
{
public:
  cDebrisShardMaster();
  ~cDebrisShardMaster();

  char *                    mModelName;
  int32                     mSpriteTemplateHandle;
  int                       mQuantity;
  float                     mRadius;
  float                     mScale;
  float                     mHeight;
};


class cDebrisMaster
{ 
public:
  cDebrisMaster();
  ~cDebrisMaster();

  
  cNameID                          mID;
  SyVector<cDebrisShardMaster *>   mShardMasters;
  float                            mRadius;

};


class cDebrisSys
{
public:
  cDebrisSys(Titan *pTitan);
  virtual ~cDebrisSys();

  void    Init();
  void    Clear();
  void    Update(float time);
  void    Spawn(const SyVect3 &loc, const SyVect3 &force,tGameID debrisID);


private:
  Titan                       *mpTitan;
  SyVector<cDebris*>           mDebris;
};

//------------------------------------------- Function Declarations

void Debris_RegisterTuningVariables();
//--------------------------------------------------------- Globals
//------------------------------------------------ Inline Functions

#endif
