/******************************************************************
  
  Module:  rule_condition.cpp
  
  Author: Sean Craig
  
  Copyright 2005 Sony Online Entertainment.  All rights reserved.
  
*******************************************************************/

//-------------------------------------------------------- Includes
#include "rule_condition.h"
#include "registry.h"
#include "titan.h"
#include "graphic.h"
//---------------------------------------------- Class Declarations
//--------------------------------------------------------- Globals
//----------------------------------------- Functions Declarations
//------------------------------------ Member Functions Definitions

cRule_Condition::cRule_Condition() :
  cRule(),
  mRemainingTime(-1.0f),
  mSourceID(ID_NONE)
{
}

cRule_Condition::cRule_Condition(const cRule_Condition& rule)
{
  *this = rule;
}

void            
cRule_Condition::Init(int numParams, cell* pParams) 
{
  SyAssertf(numParams==0 || (numParams > 0 && pParams != NULL), "Bad parameters to cRule_Condition::Init");
  if (numParams > 0 && pParams[0]>0)
  {
    mRemainingTime = ((float)pParams[0])*0.001f; // in milliseconds
  }
  else
  {
    mRemainingTime = -1.0f;
  }

  if (numParams > 1)
  {
    mSourceID = (tGameObjectID)pParams[1];
  }
  else
  {
    mSourceID = ID_NONE;
  }

}

void            
cRule_Condition::Update(float time) // returns true if it's expired
{
  if (mRemainingTime >= 0.0f) // negative time value means permanent condition
  {
    if (mRemainingTime > time)
    {
      mRemainingTime -= time;
    }
    else
    {
      mRemainingTime = 0.0f;
      SetDisabled();
    }
  }
}

//------------------------------------ cRuleInvisible

void 
cRule_Invisible::QueryFlag(cFlagPacket *packet)
{
  if (packet->IsFlag("Invisible"))
  {
    packet->Set(true);
  }
};

bool cRule_Invisible::OnAdded(tGameObjectID target)
{
  cGameObject* pObj = mpTitan->GetRegistry()->Fetch(target);

  if (pObj)
  {
    cGraphic* pGraphic = pObj->GetGraphic();
    SyAssert(pGraphic != NULL);

    if (pGraphic)
    {
      pGraphic->SetVisible(false);
    }
  }

  return true;
}

bool cRule_Invisible::OnRemoved(tGameObjectID target)
{
  cGameObject* pObj = mpTitan->GetRegistry()->Fetch(target);

  if (pObj)
  {
    cGraphic* pGraphic = pObj->GetGraphic();
    SyAssert(pGraphic != NULL);

    if (pGraphic)
    {
      pGraphic->SetVisible(true);
    }
  }

  return true;
}

//------------------------------------ cRule_Stunned
bool cRule_Stunned::OnAdded(tGameObjectID target)
{
  cGameObject* pObj = mpTitan->GetRegistry()->Fetch(target);

  if (pObj)
  {
    cGraphic* pGraphic = pObj->GetGraphic();
    SyAssert(pGraphic != NULL);

    if (pGraphic)
    {
      // todo, START playing stunned animation
//      pGraphic->SetVisible(false);
    }
  }

  return true;
}

bool cRule_Stunned::OnRemoved(tGameObjectID target)
{
  cGameObject* pObj = mpTitan->GetRegistry()->Fetch(target);

  if (pObj)
  {
    cGraphic* pGraphic = pObj->GetGraphic();
    SyAssert(pGraphic != NULL);

    if (pGraphic)
    {
      // todo, STOP playing stunned animation
//      pGraphic->SetVisible(true);
    }
  }

  return true;
}

void 
cRule_Stunned::QueryFlag(cFlagPacket *packet)
{
  if (packet->IsFlag("Stunned"))
  {
    packet->Set(true);
  }
};

//------------------------------------ cRuleInvunerable
void
cRule_Invulnerable :: CalcDamageReduced(cDamagePacket *packet)
{
  packet->SetTotal(0,"Invulnerable",GetName());
}

//------------------------------------ cRule_PartialInvulnerability
void cRule_PartialInvulnerability::Init(int numParams, cell* pParams)
{
  cRule_Condition::Init(numParams, pParams);

  if (numParams > 2)
  {
    mDmgMult = ((float)pParams[2])*0.01f;
    SyAssertf(mDmgMult >= 0.0f && mDmgMult < 1.0f, "Bad parameter on cRule_PartialInvulnerability Init");
  }
}

void
cRule_PartialInvulnerability :: CalcDamageReduced(cDamagePacket *packet)
{
  packet->SetTotal((int)(((float)packet->GetTotal())*mDmgMult),"Invulnerable",GetName());
}

// EOF
