/******************************************************************
  
  Module:  rule_inventory.cpp
  
  Author: Sean Craig
  
  Copyright 2005 Sony Online Entertainment.  All rights reserved.
  
*******************************************************************/

//-------------------------------------------------------- Includes
#include "rule_inventory.h"
#include "item.h"
//---------------------------------------------- Class Declarations

class cInventoryRule_Base: public cInventoryRule
{
public:

  virtual void    CalcDefense(cDamagePacket *packet);
  virtual void    CalcDamageInitial(cDamagePacket *packet);
};
//----------------------------------------- Functions Declarations
//------------------------------------ Member Functions Definitions

//---------------------------------------- InventoryRuleContainer

cInventoryRuleContainer::cInventoryRuleContainer()
{
  mpBase = new cInventoryRule_Base();

  // add enhancement effects
}

cInventoryRuleContainer::~cInventoryRuleContainer()
{
  delete mpBase;


  int curIndex;
  for (curIndex = mEnhancementEffects.Begin();
       curIndex != mEnhancementEffects.End();
       curIndex = mEnhancementEffects.Next(curIndex))
  {
    delete mEnhancementEffects(curIndex);
  }

  mEnhancementEffects.Clear();
}

void           
cInventoryRuleContainer::SetTitan(Titan *titan)
{ 
  mpBase->SetTitan(titan);
};


void 
cInventoryRuleContainer::ProcessPacket(cItem *item,cRulePacket *packet)
{
  mpBase->SetItem(item);
  mpBase->ProcessPacket(packet);

  // todo: call relevent enhancement effects
}


//---------------------------------------- InventoryRule_Base

void    
cInventoryRule_Base::CalcDefense(cDamagePacket *packet)
{
  packet->AddTotal(mpItem->GetMaster()->mDefenseBonus,"Item",mpItem->GetMaster()->mID.GetName());
}

void    
cInventoryRule_Base::CalcDamageInitial(cDamagePacket *packet)
{
  packet->AddTotal(mpItem->GetMaster()->mBaseDamageBonus,"Item",mpItem->GetMaster()->mID.GetName());
}

// EOF
