/////////////////////////////////////////////////////////////////////////////
// Name:        PawnDebug.cpp
// Purpose:     
// Author:      Vince Harron
// Modified by: 
// Created:     10/04/05 12:04:51
// RCS-ID:      
// Copyright:   2005 Sony Online Entertainment
// Licence:     
/////////////////////////////////////////////////////////////////////////////

#if defined(__GNUG__) && !defined(__APPLE__)
#pragma implementation "PawnDebug.h"
#endif

// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif

////@begin includes
////@end includes

#include "PawnDebug.h"

////@begin XPM images
////@end XPM images

/*!
 * PawnDebug type definition
 */

IMPLEMENT_DYNAMIC_CLASS( PawnDebug, wxDialog )

/*!
 * PawnDebug event table definition
 */

BEGIN_EVENT_TABLE( PawnDebug, wxDialog )

////@begin PawnDebug event table entries
    EVT_CLOSE( PawnDebug::OnCloseWindow )
    EVT_CHAR( PawnDebug::OnChar )

    EVT_BUTTON( ID_BUTTON_RUN, PawnDebug::OnButtonRunClick )

    EVT_BUTTON( ID_BUTTON_STEP, PawnDebug::OnButtonStepClick )

    EVT_BUTTON( ID_BUTTON_DEBUG_OFF, PawnDebug::OnButtonDebugOffClick )

////@end PawnDebug event table entries

END_EVENT_TABLE()

/*!
 * PawnDebug constructors
 */

PawnDebug::PawnDebug( )
{
}

PawnDebug::PawnDebug( wxWindow* parent, wxWindowID id, const wxString& caption, const wxPoint& pos, const wxSize& size, long style )
{
    Create(parent, id, caption, pos, size, style);
}

/*!
 * PawnDebug creator
 */

bool PawnDebug::Create( wxWindow* parent, wxWindowID id, const wxString& caption, const wxPoint& pos, const wxSize& size, long style )
{
////@begin PawnDebug member initialisation
    mpVariables = NULL;
    mpSourceView = NULL;
////@end PawnDebug member initialisation

////@begin PawnDebug creation
    SetExtraStyle(GetExtraStyle()|wxWS_EX_BLOCK_EVENTS);
    wxDialog::Create( parent, id, caption, pos, size, style );

    CreateControls();
    GetSizer()->Fit(this);
    GetSizer()->SetSizeHints(this);
    Centre();
////@end PawnDebug creation

    mpSourceView->SetValue( wxT("bubba, baby") );
    return TRUE;
}

/*!
 * Control creation for PawnDebug
 */

void PawnDebug::CreateControls()
{    
////@begin PawnDebug content construction
    // Generated by DialogBlocks, 10/27/05 10:55:37 (unregistered)

    PawnDebug* itemDialog1 = this;

    wxBoxSizer* itemBoxSizer2 = new wxBoxSizer(wxVERTICAL);
    itemDialog1->SetSizer(itemBoxSizer2);

    mpVariables = new wxTextCtrl( itemDialog1, ID_VARIABLES, _T(""), wxDefaultPosition, wxDefaultSize, wxTE_MULTILINE|wxTE_READONLY );
    itemBoxSizer2->Add(mpVariables, 1, wxGROW|wxALL, 5);

    mpSourceView = new wxTextCtrl( itemDialog1, ID_TEXTCTRL, _T(""), wxDefaultPosition, wxSize(400, 150), wxTE_MULTILINE|wxTE_READONLY|wxHSCROLL );
    itemBoxSizer2->Add(mpSourceView, 1, wxGROW|wxALL, 5);

    wxBoxSizer* itemBoxSizer5 = new wxBoxSizer(wxHORIZONTAL);
    itemBoxSizer2->Add(itemBoxSizer5, 0, wxALIGN_LEFT, 5);

    wxButton* itemButton6 = new wxButton( itemDialog1, ID_BUTTON_RUN, _("Run"), wxDefaultPosition, wxDefaultSize, 0 );
    itemBoxSizer5->Add(itemButton6, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

    wxButton* itemButton7 = new wxButton( itemDialog1, ID_BUTTON_STEP, _("Step"), wxDefaultPosition, wxDefaultSize, 0 );
    itemBoxSizer5->Add(itemButton7, 0, wxALIGN_CENTER_VERTICAL|wxRIGHT|wxTOP|wxBOTTOM, 5);

    wxButton* itemButton8 = new wxButton( itemDialog1, ID_BUTTON_DEBUG_OFF, _("Debug Off"), wxDefaultPosition, wxDefaultSize, 0 );
    itemBoxSizer5->Add(itemButton8, 0, wxALIGN_CENTER_VERTICAL|wxRIGHT|wxTOP|wxBOTTOM, 5);

////@end PawnDebug content construction
}

/*!
 * Should we show tooltips?
 */

bool PawnDebug::ShowToolTips()
{
    return TRUE;
}

/*!
 * Get bitmap resources
 */

wxBitmap PawnDebug::GetBitmapResource( const wxString& name )
{
    // Bitmap retrieval
////@begin PawnDebug bitmap retrieval
    wxUnusedVar(name);
    return wxNullBitmap;
////@end PawnDebug bitmap retrieval
}

/*!
 * Get icon resources
 */

wxIcon PawnDebug::GetIconResource( const wxString& name )
{
    // Icon retrieval
////@begin PawnDebug icon retrieval
    wxUnusedVar(name);
    return wxNullIcon;
////@end PawnDebug icon retrieval
}
/*!
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON_RUN
 */

void PawnDebug::OnButtonRunClick( wxCommandEvent& event )
{
  mResult = RESULT_RUN;
  EndModal( wxID_OK );
}

/*!
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON_STEP
 */

void PawnDebug::OnButtonStepClick( wxCommandEvent& event )
{
  mResult = RESULT_STEP;
  EndModal( wxID_OK );
}

/*!
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON_DEBUG_OFF
 */

void PawnDebug::OnButtonDebugOffClick( wxCommandEvent& event )
{
  mResult = RESULT_STOP_DEBUGGING;
  EndModal( wxID_OK );
}


/*!
 * wxEVT_CLOSE_WINDOW event handler for ID_DIALOG
 */

void PawnDebug::OnCloseWindow( wxCloseEvent& event )
{
  EndModal( wxID_OK );
}

int GetLine(const char *source, wxString &dest)
{
  int counter = 0;
  dest.Clear();
  
  while (*source != '\0')
  {
    ++counter;
   
    dest.Append(*source);
    if (*source == '\n')
    {
      return counter;
    }
    ++source;
  }
  return counter;
}

void  PawnDebug::SetSource(const wxString &source,int linenum)
{
  wxString line;
  wxString screen;
  int character = 0;
  int linelen =0;
  for (int ii=0;ii<linenum;++ii)
  {
    linelen =  GetLine(&source.c_str()[character],line);
    character += linelen;
    if (linelen == 0)
    {
      break;
    }
    screen.Append("   ");
    screen.Append(line);
    
  }

  linelen =  GetLine(&source.c_str()[character],line);
  character += linelen;
  screen.Append(">>");
  screen.Append(line);

  while (linelen != 0)
  {
    linelen =  GetLine(&source.c_str()[character],line);
    if (linelen == 0)
    {
      break;
    }
    character += linelen;
    screen.Append("   ");
    screen.Append(line);
  }

  mpSourceView->SetValue(screen);
  int screen_start = linenum - 5;

  if (screen_start < 0) screen_start = 0;
  wxTextPos pos = mpSourceView->XYToPosition(0, screen_start);
  //mpSourceView->UpdateScrollbars();
  mpSourceView->ShowPosition(pos);
}

void  PawnDebug::SetVariables(const wxString &source)
{
  mpVariables->SetValue(source);
}
/*!
 * wxEVT_CHAR event handler for ID_DIALOG
 */

void PawnDebug::OnChar( wxKeyEvent& event )
{
  switch (event.GetKeyCode())
  {
  case 'R':
    mResult = RESULT_RUN;
    EndModal( wxID_OK );
    break;
  case 'S':
    mResult = RESULT_STEP;
    EndModal( wxID_OK );
    break;
  case 'O':
    mResult = RESULT_STOP_DEBUGGING;
    EndModal( wxID_OK );
    break;
    default:
    // Before editing this code, remove the block markers.
    event.Skip();
  }
}


