/********************************************************************

  Module: TiActivateWindow

  Author: Carlo Ordonez

  Description:

    Displays message from activated object

  Copyright 2005 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#include "TiActivateWindow.h"
#include "TitanI.h"
//#include "SyDebug.h"

IMPLEMENT_CLASS( TiActivateWindow, TiWindow )

BEGIN_EVENT_TABLE( TiActivateWindow, TiWindow )
END_EVENT_TABLE()

//***********************************************************************
// Constructor
//***********************************************************************

TiActivateWindow::TiActivateWindow( wxWindow* pParent, TitanI* pTitan, int PlayerId, const wxString& Name, int WindowId )
: TiWindow( pParent, pTitan, PlayerId, Name, WindowId )
{
  wxBoxSizer* pSizer = new wxBoxSizer( wxVERTICAL );
  SetSizer( pSizer );

  int growFactor = 1;
  int border = 5;

  mpStatic = new wxStaticText( this, wxID_STATIC, _("") );
  pSizer->Add( mpStatic, growFactor, wxALL, border );

  pSizer->SetSizeHints( this );
  Layout();
  Centre();
}

//***********************************************************************
// Destructor
//***********************************************************************

TiActivateWindow::~TiActivateWindow()
{
  mpStatic->Destroy();
}

//***********************************************************************
// SetText
//***********************************************************************

void TiActivateWindow::SetText( const wxString& Text )
{
  if( Text.Length() == 0 )
  {
    Close( false );
  }
  else if( mText.Cmp( Text ) != 0 )
  {
    // text has changed
    bool instant = mText.Length() > 0;
    mText = Text;

    Close( true );
    Open( instant );
  }
}

//***********************************************************************
// OnProcess
//***********************************************************************

void TiActivateWindow::OnProcess()
{
  // update text
  if( IsClosed() )
  {
    mText = _("");
  }
  mpStatic->SetLabel( mText );

  // update dimensions
  GetSizer()->SetSizeHints( this );
  Layout();

  // update location
  int y = GetParent()->GetSize().GetHeight() - GetSize().GetHeight() - 20;
  Centre( wxHORIZONTAL );
  SetSize( -1, y, -1, -1, wxSIZE_USE_EXISTING );
}

