/********************************************************************

  Module: TiCharacterWindow

  Author: Carlo Ordonez

  Description:

    Contains windows for equipment, inventory, stats, skills, quests.

  Copyright 2005 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#include "TiCharacterWindow.h"
#include "TiEquipWindow.h"
#include "TiInventoryWindow.h"
#include "TiStatsWindow.h"
#include "TiSkillsWindow.h"
#include "TiQuestWindow.h"
#include "TiWindowEvent.h"

IMPLEMENT_CLASS( TiCharacterWindow, TiWindow )

BEGIN_EVENT_TABLE( TiCharacterWindow, TiWindow )
EVT_KEY_DOWN( TiCharacterWindow::OnKeyDown )
EVT_SET_FOCUS( TiCharacterWindow::OnSetFocus )
EVT_NOTEBOOK_PAGE_CHANGED( ID_CHARACTER_NOTEBOOK, TiCharacterWindow::OnPageChanged )
END_EVENT_TABLE()

//***********************************************************************
// Constructor
//***********************************************************************

TiCharacterWindow::TiCharacterWindow( wxWindow* pParent, TitanI* pTitan, int PlayerId, const wxString& Name, int WindowId )
: TiWindow( pParent, pTitan, PlayerId, Name, WindowId )
{
  wxBoxSizer* pSizer = new wxBoxSizer( wxHORIZONTAL );
  SetSizer( pSizer );

  int growFactor = 1;
  int border = 5;

  mpNotebook = new wxNotebook( this, ID_CHARACTER_NOTEBOOK, wxDefaultPosition, wxSize(500,400), wxNB_TOP );
  pSizer->Add( mpNotebook, growFactor, wxGROW|wxALL, border );

  TiEquipWindow* equip    = new TiEquipWindow( this, mpTitan, PlayerId );
  TiInventoryWindow* inv  = new TiInventoryWindow( this, mpTitan, PlayerId );
  TiStatsWindow* stats    = new TiStatsWindow( this, mpTitan, PlayerId );
  TiSkillsWindow* skills  = new TiSkillsWindow( this, mpTitan, PlayerId );
  TiQuestWindow* quests   = new TiQuestWindow( this, mpTitan, PlayerId );

  mpNotebook->AddPage( equip,   _("Equip") );
  mpNotebook->AddPage( inv,     _("Inventory") );
  mpNotebook->AddPage( stats,   _("Stats") );
  mpNotebook->AddPage( skills,  _("Skills") );
  mpNotebook->AddPage( quests,  _("Quests") );

  pSizer->SetSizeHints( this );
  Layout();
  Center();
}

//***********************************************************************
// Destructor
//***********************************************************************

TiCharacterWindow::~TiCharacterWindow()
{
  mpNotebook->Destroy();
}

//***********************************************************************
// OnKeyDown
//***********************************************************************

void TiCharacterWindow::OnKeyDown( wxKeyEvent& event )
{
  switch( event.GetKeyCode() )
  {
  case WXK_ESCAPE:
  case WXK_F1:
    {
      TiWindowEvent event( TIWINDOW_CLOSE, GetId() );
      ProcessEvent( event );
    }
    return;

  case WXK_PRIOR:
  case WXK_HOME:
    mpNotebook->AdvanceSelection( false );
    return;

  case WXK_NEXT:
  case WXK_END:
    mpNotebook->AdvanceSelection( true );
    return;
  }
}

//***********************************************************************
// OnSetFocus
//***********************************************************************

void TiCharacterWindow::OnSetFocus( wxFocusEvent& event )
{
  wxWindow* pSel = mpNotebook->GetPage( mpNotebook->GetSelection() );
  pSel->SetFocus();
}

//***********************************************************************
// OnPageChanged
//***********************************************************************

void TiCharacterWindow::OnPageChanged( wxNotebookEvent& event )
{
  wxWindow* pSel = mpNotebook->GetPage( mpNotebook->GetSelection() );
  pSel->SetFocus();
}
