/********************************************************************

  Module: TiCharacterWindow

  Author: Carlo Ordonez

  Description:

    Contains windows for equipment, inventory, stats, skills, quests.

  Copyright 2005 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#ifndef _TiCharacterWindow_h_
#define _TiCharacterWindow_h_

#include "TiWindow.h"
#include "wx/notebook.h"

#define ID_TITAN_CHARACTER    (wxID_HIGHEST + 0x0500)
#define ID_CHARACTER_NOTEBOOK (ID_TITAN_CHARACTER + 0x01)

class TitanI;
class wxNotebook;

class TiCharacterWindow : public TiWindow
{
public:
  TiCharacterWindow( wxWindow* pParent, TitanI* pTitan, int PlayerId, const wxString& Name = _("CharacterWindow"), int WindowId = ID_TITAN_CHARACTER );
  ~TiCharacterWindow();

private:

  virtual void      OnKeyDown( wxKeyEvent& event );
  void              OnSetFocus( wxFocusEvent& event );
  void              OnPageChanged( wxNotebookEvent& event );

  wxNotebook*       mpNotebook;

  DECLARE_CLASS( TiCharacterWindow )
  DECLARE_EVENT_TABLE()
};

#endif

