/********************************************************************

  Module: TiInventoryWindow

  Author: Carlo Ordonez

  Description:

    Inventory window (all items)

  Copyright 2005 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#include "TiInventoryWindow.h"
#include "TiListView.h"
#include "TitanI.h"

IMPLEMENT_CLASS( TiInventoryWindow, TiWindow )

BEGIN_EVENT_TABLE( TiInventoryWindow, TiWindow )
EVT_KEY_DOWN( TiInventoryWindow::OnKeyDown )
EVT_PAINT( TiInventoryWindow::OnPaint )
EVT_SET_FOCUS( TiInventoryWindow::OnSetFocus )
EVT_SIZE( TiInventoryWindow::OnSize )
END_EVENT_TABLE()

//***********************************************************************
// Constructor
//***********************************************************************

TiInventoryWindow::TiInventoryWindow( wxWindow* pParent, TitanI* pTitan, int PlayerId, const wxString& Name, int WindowId )
: TiWindow( pParent, pTitan, PlayerId, Name, WindowId )
{
  wxBoxSizer* pSizer = new wxBoxSizer( wxVERTICAL );
  SetSizer( pSizer );

  mpListView = new TiListView( this, ID_TITAN_INVENTORY_LIST, wxLC_REPORT|wxLC_SINGLE_SEL|wxLC_NO_HEADER );
  mpListView->InsertColumn( 0, _("Items") );
  pSizer->Add( mpListView, 1, wxGROW|wxALL, 5 );

  mpDescription = new wxTextCtrl( this, ID_TITAN_INVENTORY_DESC, _(""), wxDefaultPosition, wxDefaultSize, wxTE_MULTILINE|wxTE_READONLY );
  pSizer->Add( mpDescription, 1, wxGROW|wxALL, 5 );

  pSizer->SetSizeHints( this );
  Layout();
  Center();
}

//***********************************************************************
// Destructor
//***********************************************************************

TiInventoryWindow::~TiInventoryWindow()
{
  mpListView->Destroy();
  mpDescription->Destroy();
}

//***********************************************************************
// OnKeyDown
//***********************************************************************

void TiInventoryWindow::OnKeyDown( wxKeyEvent& event )
{
  switch( event.GetKeyCode() )
  {
  case WXK_UP:
    mpListView->Prev();
    return;

  case WXK_DOWN:
    mpListView->Next();
    return;
  }

  // default
  GetParent()->ProcessEvent( event );
}

//***********************************************************************
// OnPaint
//***********************************************************************

void TiInventoryWindow::OnPaint( wxPaintEvent& event )
{
  TiWindow::OnPaint( event );
  wxPaintDC dc( this );

  long sel = mpListView->GetFirstSelected();
  if( sel >= 0 )
  {
    int itemHandle = (int)mpListView->GetItemData( sel );
    mpDescription->SetValue( _(mpTitan->InventoryGetItemDescription(mPlayerId,itemHandle)) );
  }
}

//***********************************************************************
// OnSetFocus
//***********************************************************************

void TiInventoryWindow::OnSetFocus( wxFocusEvent& event )
{
  mpListView->DeleteAllItems();
  for( int i = 0; i < mpTitan->InventoryGetItemCount(mPlayerId); i++ )
  {
    wxListItem item;
    item.SetId( mpListView->GetItemCount() );
    item.SetText( _(mpTitan->InventoryGetItemName(mPlayerId,i)) );
    item.SetData( i );
    mpListView->InsertItem( item );
  }
  if( mpListView->GetItemCount() > 0 && mpListView->GetFirstSelected() < 0 )
  {
    mpListView->Select( 0 );
  }
}

//***********************************************************************
// OnSize
//***********************************************************************

void TiInventoryWindow::OnSize( wxSizeEvent& event )
{
  wxSize size = event.GetSize();
}
