/********************************************************************

  Module: TiItemDescription

  Author: Carlo Ordonez

  Description:

    Window for item descriptions

  Copyright 2005 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#ifndef _TiItemDescription_h_
#define _TiItemDescription_h_

#include "TiWindow.h"

#define ID_TITAN_ITEM_DESCRIPTION (wxID_HIGHEST + 0x0300)

class TitanI;
class TiItemDescription : public TiWindow
{
public:

  TiItemDescription( wxWindow* pParent, TitanI* pTitan, int PlayerId, const wxString& Name = _T("ItemDescription"), int WindowId = ID_TITAN_ITEM_DESCRIPTION );
  ~TiItemDescription();

  int               GetItemHandle() const { return( mItemHandle ); }
  void              SetItemHandle( int ItemHandle ) { mItemHandle = ItemHandle; }

  void              SetTitle( const wxString& Title );

private:

  virtual void      OnPaint( wxPaintEvent& event );

  int               mItemHandle;
  wxStaticText*     mpTitle;
  wxStaticText*     mpName;
  wxStaticText*     mpQuantity;
  wxStaticText*     mpValue;
  wxStaticText*     mpBonus;
  
  DECLARE_CLASS( TiItemDescription )
  DECLARE_EVENT_TABLE()
};

#endif

