/********************************************************************

  Module: TiItemEvent

  Author: Carlo Ordonez

  Description:

    Events the item windows fire.

  Copyright 2005 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#ifndef _TiItemEvent_h_
#define _TiItemEvent_h_

#include "wx/event.h"

DECLARE_EVENT_TYPE( TIITEM_ACTIVATE, -1 )
DECLARE_EVENT_TYPE( TIITEM_DROP, -1 )

// for subscribing via event tables
#define EVT_TIITEM_ACTIVATE(func)     DECLARE_EVENT_TABLE_ENTRY( TIITEM_ACTIVATE, wxID_ANY, wxID_ANY, (wxObjectEventFunction)(wxEventFunction)wxStaticCastEvent( TiItemEventFunction, &func ), (wxObject*)NULL ),
#define EVT_TIITEM_DROP(func)         DECLARE_EVENT_TABLE_ENTRY( TIITEM_DROP, wxID_ANY, wxID_ANY, (wxObjectEventFunction)(wxEventFunction)wxStaticCastEvent( TiItemEventFunction, &func ), (wxObject*)NULL ),

class TiItemEvent : public wxCommandEvent
{
public:
  TiItemEvent( int Command, int WindowId );

  int       GetItemHandle() const { return( mItemHandle ); }
  void      SetItemHandle( int ItemHandle ) { mItemHandle = ItemHandle; }

private:
  int       mItemHandle;
};

// for subscribing via wxEvtHandler::Connect()
typedef void (wxEvtHandler::*TiItemEventFunction)(TiItemEvent&);

#endif

