/********************************************************************

  Module: TiStatsWindow

  Author: Carlo Ordonez

  Description:

    Character Stats Window

  Copyright 2005 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#include "TiStatsWindow.h"
#include "TitanI.h"

IMPLEMENT_CLASS( TiStatsWindow, TiWindow )

BEGIN_EVENT_TABLE( TiStatsWindow, TiWindow )
EVT_KEY_DOWN( TiStatsWindow::OnKeyDown )
EVT_PAINT( TiStatsWindow::OnPaint )
END_EVENT_TABLE()

//***********************************************************************
// Constructor
//***********************************************************************

TiStatsWindow::TiStatsWindow( wxWindow* pParent, TitanI* pTitan, int PlayerId, const wxString& Name, int WindowId )
: TiWindow( pParent, pTitan, PlayerId, Name, WindowId )
{
  wxBoxSizer* itemBoxSizer = new wxBoxSizer(wxVERTICAL);
  this->SetSizer(itemBoxSizer);

  // name, rank and class
  mpName = new wxStaticText( this, wxID_STATIC, _("Timmy"), wxDefaultPosition, wxDefaultSize, wxALIGN_CENTRE|wxSTATIC_BORDER );
  itemBoxSizer->Add(mpName, 0, wxGROW|wxLEFT|wxRIGHT|wxTOP|wxADJUST_MINSIZE, 5);
  mpClass = new wxStaticText( this, wxID_STATIC, _("Level 6 Brute"), wxDefaultPosition, wxDefaultSize, wxALIGN_CENTRE|wxSTATIC_BORDER );
  itemBoxSizer->Add(mpClass, 0, wxGROW|wxALL|wxADJUST_MINSIZE, 5);

  wxBoxSizer* itemBoxSizer5 = new wxBoxSizer(wxHORIZONTAL);
  itemBoxSizer->Add(itemBoxSizer5, 1, wxGROW, 5);
  wxBoxSizer* itemBoxSizer6 = new wxBoxSizer(wxVERTICAL);
  itemBoxSizer5->Add(itemBoxSizer6, 1, wxGROW|wxTOP|wxBOTTOM, 5);
  wxBoxSizer* itemBoxSizer7 = new wxBoxSizer(wxHORIZONTAL);
  itemBoxSizer6->Add(itemBoxSizer7, 1, wxGROW|wxBOTTOM, 5);
  wxBoxSizer* itemBoxSizer8 = new wxBoxSizer(wxVERTICAL);
  itemBoxSizer7->Add(itemBoxSizer8, 1, wxGROW|wxBOTTOM, 5);
  wxBoxSizer* itemBoxSizer11 = new wxBoxSizer(wxVERTICAL);
  itemBoxSizer7->Add(itemBoxSizer11, 1, wxGROW|wxBOTTOM, 5);

  // experience
  mpExp = new wxStaticText( this, wxID_STATIC, _("Experience"), wxDefaultPosition, wxDefaultSize, wxALIGN_RIGHT|wxSTATIC_BORDER );
  itemBoxSizer8->Add(mpExp, 0, wxGROW|wxLEFT|wxRIGHT|wxTOP|wxADJUST_MINSIZE, 5);
  mpNextLevel = new wxStaticText( this, wxID_STATIC, _("Next Level"), wxDefaultPosition, wxDefaultSize, wxALIGN_RIGHT|wxSTATIC_BORDER );
  itemBoxSizer8->Add(mpNextLevel, 0, wxGROW|wxLEFT|wxRIGHT|wxTOP|wxADJUST_MINSIZE, 5);
  mpExpValue = new wxStaticText( this, wxID_STATIC, _("20254"), wxDefaultPosition, wxDefaultSize, wxALIGN_CENTRE|wxSTATIC_BORDER );
  itemBoxSizer11->Add(mpExpValue, 0, wxGROW|wxLEFT|wxRIGHT|wxTOP|wxADJUST_MINSIZE, 5);
  mpNextLevelValue = new wxStaticText( this, wxID_STATIC, _("21600"), wxDefaultPosition, wxDefaultSize, wxALIGN_CENTRE|wxSTATIC_BORDER );
  itemBoxSizer11->Add(mpNextLevelValue, 0, wxGROW|wxLEFT|wxRIGHT|wxTOP|wxADJUST_MINSIZE, 5);

  wxBoxSizer* itemBoxSizer14 = new wxBoxSizer(wxHORIZONTAL);
  itemBoxSizer6->Add(itemBoxSizer14, 1, wxGROW|wxBOTTOM, 5);
  wxBoxSizer* itemBoxSizer15 = new wxBoxSizer(wxVERTICAL);
  itemBoxSizer14->Add(itemBoxSizer15, 1, wxGROW|wxBOTTOM, 5);
  wxBoxSizer* itemBoxSizer18 = new wxBoxSizer(wxVERTICAL);
  itemBoxSizer14->Add(itemBoxSizer18, 1, wxGROW|wxBOTTOM, 5);

  // health & block
  mpHealth = new wxStaticText( this, wxID_STATIC, _("Health"), wxDefaultPosition, wxDefaultSize, wxALIGN_RIGHT|wxSTATIC_BORDER );
  itemBoxSizer15->Add(mpHealth, 0, wxGROW|wxLEFT|wxRIGHT|wxTOP|wxADJUST_MINSIZE, 5);
  mpBlock = new wxStaticText( this, wxID_STATIC, _("Block"), wxDefaultPosition, wxDefaultSize, wxALIGN_RIGHT|wxSTATIC_BORDER );
  itemBoxSizer15->Add(mpBlock, 0, wxGROW|wxLEFT|wxRIGHT|wxTOP|wxADJUST_MINSIZE, 5);
  mpHealthValue = new wxStaticText( this, wxID_STATIC, _("132/132"), wxDefaultPosition, wxDefaultSize, wxALIGN_CENTRE|wxSTATIC_BORDER );
  itemBoxSizer18->Add(mpHealthValue, 0, wxGROW|wxLEFT|wxRIGHT|wxTOP|wxADJUST_MINSIZE, 5);
  mpBlockValue = new wxStaticText( this, wxID_STATIC, _("57/57"), wxDefaultPosition, wxDefaultSize, wxALIGN_CENTRE|wxSTATIC_BORDER );
  itemBoxSizer18->Add(mpBlockValue, 0, wxGROW|wxLEFT|wxRIGHT|wxTOP|wxADJUST_MINSIZE, 5);

  wxBoxSizer* itemBoxSizer21 = new wxBoxSizer(wxHORIZONTAL);
  itemBoxSizer6->Add(itemBoxSizer21, 1, wxGROW|wxLEFT|wxRIGHT, 5);

  // armor
  mpArmor = new wxStaticText( this, wxID_STATIC, _("Armor"), wxDefaultPosition, wxDefaultSize, wxALIGN_RIGHT|wxSTATIC_BORDER );
  itemBoxSizer21->Add(mpArmor, 1, wxALIGN_CENTER_VERTICAL|wxRIGHT|wxADJUST_MINSIZE, 5);
  mpArmorValue = new wxStaticText( this, wxID_STATIC, _("205"), wxDefaultPosition, wxDefaultSize, wxALIGN_CENTRE|wxSTATIC_BORDER );
  itemBoxSizer21->Add(mpArmorValue, 1, wxALIGN_CENTER_VERTICAL|wxLEFT|wxADJUST_MINSIZE, 5);

  wxBoxSizer* itemBoxSizer24 = new wxBoxSizer(wxHORIZONTAL);
  itemBoxSizer6->Add(itemBoxSizer24, 1, wxGROW|wxBOTTOM, 5);
  wxBoxSizer* itemBoxSizer25 = new wxBoxSizer(wxVERTICAL);
  itemBoxSizer24->Add(itemBoxSizer25, 1, wxGROW|wxBOTTOM, 5);
  wxBoxSizer* itemBoxSizer28 = new wxBoxSizer(wxVERTICAL);
  itemBoxSizer24->Add(itemBoxSizer28, 1, wxGROW|wxBOTTOM, 5);

  // attack & damage
  mpAttack = new wxStaticText( this, wxID_STATIC, _("Attack"), wxDefaultPosition, wxDefaultSize, wxALIGN_RIGHT|wxSTATIC_BORDER );
  itemBoxSizer25->Add(mpAttack, 0, wxGROW|wxLEFT|wxRIGHT|wxTOP|wxADJUST_MINSIZE, 5);
  mpDamage = new wxStaticText( this, wxID_STATIC, _("Damage"), wxDefaultPosition, wxDefaultSize, wxALIGN_RIGHT|wxSTATIC_BORDER );
  itemBoxSizer25->Add(mpDamage, 0, wxGROW|wxLEFT|wxRIGHT|wxTOP|wxADJUST_MINSIZE, 5);
  mpAttackValue = new wxStaticText( this, wxID_STATIC, _("133"), wxDefaultPosition, wxDefaultSize, wxALIGN_CENTRE|wxSTATIC_BORDER );
  itemBoxSizer28->Add(mpAttackValue, 0, wxGROW|wxLEFT|wxRIGHT|wxTOP|wxADJUST_MINSIZE, 5);
  mpDamageValue = new wxStaticText( this, wxID_STATIC, _("62-71"), wxDefaultPosition, wxDefaultSize, wxALIGN_CENTRE|wxSTATIC_BORDER );
  itemBoxSizer28->Add(mpDamageValue, 0, wxGROW|wxLEFT|wxRIGHT|wxTOP|wxADJUST_MINSIZE, 5);

  wxBoxSizer* itemBoxSizer31 = new wxBoxSizer(wxHORIZONTAL);
  itemBoxSizer6->Add(itemBoxSizer31, 0, wxGROW, 5);
  wxBoxSizer* itemBoxSizer32 = new wxBoxSizer(wxVERTICAL);
  itemBoxSizer31->Add(itemBoxSizer32, 1, wxGROW|wxBOTTOM, 5);
  wxBoxSizer* itemBoxSizer37 = new wxBoxSizer(wxVERTICAL);
  itemBoxSizer31->Add(itemBoxSizer37, 1, wxGROW|wxBOTTOM, 5);

  // STR, INT, DEX, STA
  mpStr = new wxStaticText( this, wxID_STATIC, _("Strength"), wxDefaultPosition, wxDefaultSize, wxALIGN_RIGHT|wxSTATIC_BORDER );
  itemBoxSizer32->Add(mpStr, 0, wxGROW|wxLEFT|wxRIGHT|wxTOP|wxADJUST_MINSIZE, 5);
  mpInt = new wxStaticText( this, wxID_STATIC, _("Intelligence"), wxDefaultPosition, wxDefaultSize, wxALIGN_RIGHT|wxSTATIC_BORDER );
  itemBoxSizer32->Add(mpInt, 0, wxGROW|wxLEFT|wxRIGHT|wxTOP|wxADJUST_MINSIZE, 5);
  mpDex = new wxStaticText( this, wxID_STATIC, _("Dexterity"), wxDefaultPosition, wxDefaultSize, wxALIGN_RIGHT|wxSTATIC_BORDER );
  itemBoxSizer32->Add(mpDex, 0, wxGROW|wxLEFT|wxRIGHT|wxTOP|wxADJUST_MINSIZE, 5);
  mpSta = new wxStaticText( this, wxID_STATIC, _("Stamina"), wxDefaultPosition, wxDefaultSize, wxALIGN_RIGHT|wxSTATIC_BORDER );
  itemBoxSizer32->Add(mpSta, 0, wxGROW|wxLEFT|wxRIGHT|wxTOP|wxADJUST_MINSIZE, 5);
  mpStrValue = new wxStaticText( this, wxID_STATIC, _("49"), wxDefaultPosition, wxDefaultSize, wxALIGN_CENTRE|wxSTATIC_BORDER );
  itemBoxSizer37->Add(mpStrValue, 0, wxGROW|wxLEFT|wxRIGHT|wxTOP|wxADJUST_MINSIZE, 5);
  mpIntValue = new wxStaticText( this, wxID_STATIC, _("27"), wxDefaultPosition, wxDefaultSize, wxALIGN_CENTRE|wxSTATIC_BORDER );
  itemBoxSizer37->Add(mpIntValue, 0, wxGROW|wxLEFT|wxRIGHT|wxTOP|wxADJUST_MINSIZE, 5);
  mpDexValue = new wxStaticText( this, wxID_STATIC, _("28"), wxDefaultPosition, wxDefaultSize, wxALIGN_CENTRE|wxSTATIC_BORDER );
  itemBoxSizer37->Add(mpDexValue, 0, wxGROW|wxLEFT|wxRIGHT|wxTOP|wxADJUST_MINSIZE, 5);
  mpStaValue = new wxStaticText( this, wxID_STATIC, _("46"), wxDefaultPosition, wxDefaultSize, wxALIGN_CENTRE|wxSTATIC_BORDER );
  itemBoxSizer37->Add(mpStaValue, 0, wxGROW|wxLEFT|wxRIGHT|wxTOP|wxADJUST_MINSIZE, 5);

  wxBoxSizer* itemBoxSizer42 = new wxBoxSizer(wxVERTICAL);
  itemBoxSizer5->Add(itemBoxSizer42, 1, wxGROW|wxLEFT|wxTOP|wxBOTTOM, 5);

  // resistances
  mpResist = new wxStaticText( this, wxID_STATIC, _("Resist"), wxDefaultPosition, wxDefaultSize, wxALIGN_CENTRE|wxSTATIC_BORDER );
  itemBoxSizer42->Add(mpResist, 0, wxGROW|wxLEFT|wxRIGHT|wxTOP|wxADJUST_MINSIZE, 5);
  mpFireValue = new wxStaticText( this, wxID_STATIC, _("0%"), wxDefaultPosition, wxDefaultSize, wxALIGN_CENTRE|wxSTATIC_BORDER );
  itemBoxSizer42->Add(mpFireValue, 1, wxGROW|wxLEFT|wxRIGHT|wxTOP|wxADJUST_MINSIZE, 5);
  mpColdValue = new wxStaticText( this, wxID_STATIC, _("0%"), wxDefaultPosition, wxDefaultSize, wxALIGN_CENTRE|wxSTATIC_BORDER );
  itemBoxSizer42->Add(mpColdValue, 1, wxGROW|wxLEFT|wxRIGHT|wxTOP|wxADJUST_MINSIZE, 5);
  mpPoisonValue = new wxStaticText( this, wxID_STATIC, _("0%"), wxDefaultPosition, wxDefaultSize, wxALIGN_CENTRE|wxSTATIC_BORDER );
  itemBoxSizer42->Add(mpPoisonValue, 1, wxGROW|wxLEFT|wxRIGHT|wxTOP|wxADJUST_MINSIZE, 5);
  mpDiseaseValue = new wxStaticText( this, wxID_STATIC, _("0%"), wxDefaultPosition, wxDefaultSize, wxALIGN_CENTRE|wxSTATIC_BORDER );
  itemBoxSizer42->Add(mpDiseaseValue, 1, wxGROW|wxLEFT|wxRIGHT|wxTOP|wxADJUST_MINSIZE, 5);
  mpMagicValue = new wxStaticText( this, wxID_STATIC, _("0%"), wxDefaultPosition, wxDefaultSize, wxALIGN_CENTRE|wxSTATIC_BORDER );
  itemBoxSizer42->Add(mpMagicValue, 1, wxGROW|wxLEFT|wxRIGHT|wxTOP|wxADJUST_MINSIZE, 5);

  // do the sizer thing
  GetSizer()->SetSizeHints( this );
  Layout();
  Centre();
}

//***********************************************************************
// OnKeyDown
//***********************************************************************

void TiStatsWindow::OnKeyDown( wxKeyEvent& event )
{
  GetParent()->GetEventHandler()->ProcessEvent( event );
}

//***********************************************************************
// OnPaint
//***********************************************************************

void TiStatsWindow::OnPaint( wxPaintEvent& event )
{
  wxPaintDC dc( this );

  TiWindow::OnPaint( event );

  // update text
  int health = mpTitan->GetPlayerHealth();
  int healthMax = mpTitan->GetPlayerHealthMax();
  mpHealthValue->SetLabel( wxString::Format( "%d/%d", health, healthMax ) );

  int block = mpTitan->GetPlayerBlock();
  int blockMax = mpTitan->GetPlayerBlockMax();
  mpBlockValue->SetLabel( wxString::Format( "%d/%d", block, blockMax ) );
}

