/********************************************************************

  Module: TiStatsWindow

  Author: Carlo Ordonez

  Description:

    Character Stats Window

  Copyright 2005 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#ifndef _TiStatsWindow_h_
#define _TiStatsWindow_h_

#include "TiWindow.h"

#define ID_TITAN_STATS (wxID_HIGHEST + 0x0200)

class TitanI;
class TiStatsWindow : public TiWindow
{
public:
  TiStatsWindow( wxWindow* pParent, TitanI* pTitan, int PlayerId, const wxString& Name = _T("StatsWindow"), int WindowId = ID_TITAN_STATS );

private:

  virtual void  OnKeyDown( wxKeyEvent& event );
  virtual void  OnPaint( wxPaintEvent& event );

private:

  wxStaticText* mpName;
  wxStaticText* mpClass;

  wxStaticText* mpHealth;
  wxStaticText* mpHealthValue;
  wxStaticText* mpBlock;
  wxStaticText* mpBlockValue;

  wxStaticText* mpExp;
  wxStaticText* mpExpValue;
  wxStaticText* mpNextLevel;
  wxStaticText* mpNextLevelValue;

  wxStaticText* mpArmor;
  wxStaticText* mpArmorValue;

  wxStaticText* mpAttack;
  wxStaticText* mpAttackValue;
  wxStaticText* mpDamage;
  wxStaticText* mpDamageValue;

  wxStaticText* mpStr;
  wxStaticText* mpStrValue;
  wxStaticText* mpInt;
  wxStaticText* mpIntValue;
  wxStaticText* mpDex;
  wxStaticText* mpDexValue;
  wxStaticText* mpSta;
  wxStaticText* mpStaValue;

  wxStaticText* mpResist;
  wxStaticText* mpFireValue;
  wxStaticText* mpColdValue;
  wxStaticText* mpPoisonValue;
  wxStaticText* mpDiseaseValue;
  wxStaticText* mpMagicValue;

  DECLARE_CLASS( TiStatsWindow )
  DECLARE_EVENT_TABLE()
};

#endif

