/********************************************************************

  Module: TiWindowEvent

  Author: Carlo Ordonez

  Description:

    Events a game window fires.

  Copyright 2005 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#ifndef _TiWindowEvent_h_
#define _TiWindowEvent_h_

#include "wx/event.h"

// event prototypes
DECLARE_EVENT_TYPE( TIWINDOW_CLOSE, -1 )

// for subscribing via event tables
#define EVT_TIWINDOW_CLOSE(winId,func)     DECLARE_EVENT_TABLE_ENTRY( TIWINDOW_CLOSE, winId, wxID_ANY, (wxObjectEventFunction)(wxEventFunction)wxStaticCastEvent( TiWindowEventFunction, &func ), (wxObject*)NULL ),

class TiWindowEvent : public wxCommandEvent
{
public:
  // Constructor
  TiWindowEvent( int Command, int Id );
};

// for subscribing via wxEvtHandler::Connect()
typedef void (wxEvtHandler::*TiWindowEventFunction)(TiWindowEvent&);

#endif

