/********************************************************************

  Module: TitanHUD

  Author: Carlo Ordonez

  Description:

    Displays name, power bars

  Copyright 2005 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#include "TitanHUD.h"
#include "SyMath.h"

TitanHUD::TitanHUD( wxFrame* pFrame, wxWindowID Id, const wxPoint& Position )
: wxWindow( pFrame, Id, Position, wxSize(200,70) )
{
  // text with player's name
  mpName = new wxStaticText( this, ID_TITANHUD_NAME, _("PlayerName"), wxPoint(5,5), wxSize(180,20), 0 );

  // health bar
  mpHealth = new wxGauge( this, ID_TITANHUD_HEALTH, 100, wxPoint(5,25), wxSize(180,20), wxGA_HORIZONTAL|wxGA_SMOOTH );
  mpHealth->SetValue(1);

  // block bar
  mpBlock = new wxGauge( this, ID_TITANHUD_BLOCK, 100, wxPoint(5,45), wxSize(180,20), wxGA_HORIZONTAL|wxGA_SMOOTH );
  mpBlock->SetValue(1);
}

TitanHUD::~TitanHUD()
{
  mpName->Destroy();
  mpHealth->Destroy();
  mpBlock->Destroy();
}

void TitanHUD::SetPlayerName( const wxString& Name )
{
  mpName->SetLabel( Name );
}

void TitanHUD::SetHealth( int Health )
{
  int health = SY_CLAMP( Health, 0, mpHealth->GetRange() );
  mpHealth->SetValue( health );
}

void TitanHUD::SetHealthMax( int HealthMax )
{
  mpHealth->SetRange( HealthMax );
}

void TitanHUD::SetBlock( int Block )
{
  int block = SY_CLAMP( Block, 0, mpBlock->GetRange() );
  mpBlock->SetValue( block );
}

void TitanHUD::SetBlockMax( int BlockMax )
{
  mpBlock->SetRange( BlockMax );
}
