#ifndef __TITANUI_H__
#define __TITANUI_H__

class SyScene;
class wxWindow;
class PawnOutput;
#include "TitanI.h"
#include "TitanController.h"
#include <map>

class TitanUI : public TitanUII
{
public:
  TitanUI( wxWindow* window );
  virtual ~TitanUI();

  // Use this method instead of Scene::Clear to give the interface an 
  // opportunity to reload its assets after the clear. 
  virtual int ClearScene();

  // Get the scene titan can use for drawing
  virtual SyScene* GetScene();
  virtual SyPerformanceStats* GetPerformanceStats();

  // Get a pointer to an interface that can be used to poll a controller state
  virtual TitanControllerI* GetController( int controllerId );

  static TitanButton GetTitanButton( int buttonIndex );
  static int         GetButtonIndex( TitanButton titanButton );

  typedef enum
  {
    CONTROLLER_MAPPING_PS2,
    CONTROLLER_MAPPING_AIRFLO,
    CONTROLLER_MAPPING_LOGITECH,
  } eControllerMapping;
  static void        SetControllerMapping(eControllerMapping mapping);

  virtual int       PawnDebugUI(const char *src, int linenum, const char *variables);
  void              PawnDebugShowOutput(bool show);
  void              PawnDebugOutput(const char *output);
private:
  wxWindow*                      mpWxWindow;
  std::map<int,TitanController*> mControllers;
  PawnOutput *                   mpPawnOutput;
};

#endif // __TITANUI_H__
