#if !defined 	IMAGEINFO_ELF_H__
#define			IMAGEINFO_ELF_H__

namespace imageinfo
{
	struct ELF32Header
	{
		uint8_t		ident[0x10];

		uint16_t	type;
		uint16_t	machine;

		uint32_t	version;
		uint32_t	entry;
		uint32_t	phoff;
		uint32_t	shoff;
		uint32_t	flags;

		uint16_t	ehsize;
		uint16_t	phentsize;
		uint16_t	phnum;
		uint16_t	shentsize;
		uint16_t	shnum;
		uint16_t	shstrndx;
	};

	struct ELF32Section
	{
		uint32_t	name;
		uint32_t	type;
		uint32_t	flags;
		uint32_t	addr;
		uint32_t	offset;
		uint32_t	size;
		uint32_t	link;
		uint32_t	info;
		uint32_t	addralign;
		uint32_t	entsize;
	};

	struct ELF32Sym
	{
		uint32_t	name;
		uint32_t	value;
		uint32_t	size;
		uint8_t		info;
		uint8_t		other;
		uint16_t	shndx;
	};


	struct ELF32Rel
	{
		uint32_t	offset;
		uint32_t	info;
	};

	struct ELF32Rela
	{
		uint32_t	offset;
		uint32_t	info;
		int32_t		addend;
	};

	struct ELF32Phdr
	{
		uint32_t	type;
		uint32_t	offset;
		uint32_t	vaddr;
		uint32_t	paddr;
		uint32_t	filesz;
		uint32_t	memsz;
		uint32_t	flags;
		uint32_t	align;
	};
}

#endif
