#ifndef KB_H_
#define KB_H_

#include"../sys/SyTypes.h"

#ifndef _WIN32

#include <types.h>
#include <usb/usbkb/libusbkb_c.h>

#endif


#ifdef _WIN32

#define KB_UP     		VK_UP
#define KB_LEFT   		VK_LEFT
#define KB_RIGHT  		VK_RIGHT
#define KB_DOWN   		VK_DOWN
#define KB_F1     		VK_F1
#define KB_F2     		VK_F2
#define KB_F3     		VK_F3
#define KB_F4     		VK_F4
#define KB_F5     		VK_F5
#define KB_F6           VK_F6
#define KB_F7           VK_F7
#define KB_F8           VK_F8
#define KB_F9           VK_F9
#define KB_F10          VK_F10
#define KB_ESC    		VK_ESCAPE
#define KB_PAGE_UP		VK_PRIOR
#define KB_PAGE_DOWN	VK_NEXT
#define KB_HOME			VK_HOME
#define KB_END			VK_END

#else

#define KB_UP     		SCE_USBKEYC_UP_ARROW
#define KB_LEFT   		SCE_USBKEYC_LEFT_ARROW
#define KB_RIGHT  		SCE_USBKEYC_RIGHT_ARROW
#define KB_DOWN   		SCE_USBKEYC_DOWN_ARROW
#define KB_F1     		SCE_USBKEYC_F1
#define KB_F2     		SCE_USBKEYC_F2
#define KB_F3     		SCE_USBKEYC_F3
#define KB_F4     		SCE_USBKEYC_F4
#define KB_F5     		SCE_USBKEYC_F5
#define KB_F6     		SCE_USBKEYC_F6
#define KB_F7     		SCE_USBKEYC_F7
#define KB_F8     		SCE_USBKEYC_F8
#define KB_F9     		SCE_USBKEYC_F9
#define KB_F10     		SCE_USBKEYC_F10
#define KB_ESC    		SCE_USBKEYC_ESCAPE
#define KB_PAGE_UP		SCE_USBKEYC_PAGE_UP
#define KB_PAGE_DOWN	SCE_USBKEYC_PAGE_DOWN
#define KB_HOME			SCE_USBKEYC_HOME
#define KB_END			SCE_USBKEYC_END

#endif

#define MAX_KEYBD 2

#define KB_MAX_KEYS 255
#define KB_FLAG_KEYDOWN  		0x01
#define KB_FLAG_KEYHIT   		0x02
#define KB_FLAG_L_SHIFT			0x04
#define KB_FLAG_R_SHIFT			0x08
#define KB_FLAG_L_CTRL			0x10
#define KB_FLAG_R_CTRL			0x20
#define KB_FLAG_L_ALT				0x40
#define KB_FLAG_R_ALT				0x80

class KB
{
public:
  KB();
  ~KB();

  void Init();
  void Shutdown();
  bool IsKeyDown( uint8 code );
  bool IsKeyHit( uint8 code );
	int	 GetKeyState( uint8 code );
  void Update();
  
private:
#ifndef _WIN32
  SceUsbKbInfo_t info;
  SceUsbKbData_t kdataPacket;
  int Arrangement[MAX_KEYBD];
  int ReadMode[MAX_KEYBD];
  
  uint8_t m_keyStatus[KB_MAX_KEYS];
  uint8_t m_oldStatus[MAX_KEYBD];

#endif  // _WIN32
  
  int m_numKB;
  int initialized;
};


#endif  // KB_H_
