/* Linker script for the SOE SPU page kernel*/

/* Currently the only major difference is the existance of the 'page_text' section.  This
   section marks the end of the kernel's LS space and the begining of the page image's.
   In the future we will be adding more special sections to control system library placment
   in LS for access from the page image.
*/



OUTPUT_FORMAT("elf32-spu", "elf32-spu", "elf32-spu")
OUTPUT_ARCH(spu)
ENTRY(main)

SEARCH_DIR("=/usr/local/lib"); SEARCH_DIR("=/lib"); SEARCH_DIR("=/usr/lib");

SECTIONS
{
  /* Read-only sections, merged into text segment: */
  PROVIDE (__executable_start = 0x0000080); . = 0x0000080;
 
  .text           :
  {
    *(.text .stub .text.* .gnu.linkonce.t.*)
    /* .gnu.warning sections are handled specially by elf32.em.  */
    *(.gnu.warning)
  } =0

  . = ALIGN(16);
  .data           :
  {
    *(.data .data.* .gnu.linkonce.d.*)
    SORT(CONSTRUCTORS)
  }

 _edata = .;
  PROVIDE (edata = .);

  /*page_text exists to ensure a pages image is loaded after all of the kernel's sections*/
	. =0x4000;
  	__page_text_start = .;
  .page_text :
  {
	  *(.page_text)
  }

  /*set the begining of the "page heap" to the region of memory following the page execution space*/

  _end = .;
  PROVIDE (end = .);

  PROVIDE (__page_heap_start = 0x24000);
  PROVIDE (__stack = 0x3fff0);

  /*TODO.  Do something with these sections.  Right now the kernel is not compiled with debug symbols.  This
  	should change at some point if the future, when c code is added to the kernel.  Once that happens, the kernel
	will occupy LS space beyond 0x7fff with the ld script in its current state.  Perhaps we can just move these
	sections to the end of LS space and pay special mind to ensure page images don't write over the kernel's debug sections
	when they exist.
  */

  /* Stabs debugging sections.  */
  .stab          0 : { *(.stab) }
  .stabstr       0 : { *(.stabstr) }
  .stab.excl     0 : { *(.stab.excl) }
  .stab.exclstr  0 : { *(.stab.exclstr) }
  .stab.index    0 : { *(.stab.index) }
  .stab.indexstr 0 : { *(.stab.indexstr) }
  .comment       0 : { *(.comment) }
  /* DWARF debug sections.
     Symbols in the DWARF debugging sections are relative to the beginning
     of the section so we begin them at 0.  */
  /* DWARF 1 */
  .debug          0 : { *(.debug) }
  .line           0 : { *(.line) }
  /* GNU DWARF 1 extensions */
  .debug_srcinfo  0 : { *(.debug_srcinfo) }
  .debug_sfnames  0 : { *(.debug_sfnames) }
  /* DWARF 1.1 and DWARF 2 */
  .debug_aranges  0 : { *(.debug_aranges) }
  .debug_pubnames 0 : { *(.debug_pubnames) }
  /* DWARF 2 */
  .debug_info     0 : { *(.debug_info .gnu.linkonce.wi.*) }
  .debug_abbrev   0 : { *(.debug_abbrev) }
  .debug_line     0 : { *(.debug_line) }
  .debug_frame    0 : { *(.debug_frame) }
  .debug_str      0 : { *(.debug_str) }
  .debug_loc      0 : { *(.debug_loc) }
  .debug_macinfo  0 : { *(.debug_macinfo) }
  /* SGI/MIPS DWARF 2 extensions */
  .debug_weaknames 0 : { *(.debug_weaknames) }
  .debug_funcnames 0 : { *(.debug_funcnames) }
  .debug_typenames 0 : { *(.debug_typenames) }
  .debug_varnames  0 : { *(.debug_varnames) }
  /DISCARD/ : { *(.note.GNU-stack) }
}
