/******************************************************************

  Module: testwindow.cpp

  Author: John Buckley

  Description:

    window initialization

  Copyright 2005 Sony Online Entertainment.  All rights reserved.

*******************************************************************/

/*
**
**	 Includes
**
*/

#include"SyTypes.h"

#ifdef _WIN32
#include<windows.h>
#else
#include<stdio.h>
#include<proc.h>
#include<sys/raw_spu.h>
#endif

/**/

/*
**
**	 Constants
**
*/

/**/


/*
**
**	 Defines
**
*/

/**/


/*
**
**	 Function Prototypes
**
*/

#ifdef _WIN32

LRESULT CALLBACK MainWndProcCallback(
                  HWND   hWnd,
                  UINT   uMsg,
                  WPARAM wParam,
                  LPARAM lParam );

#endif

/**/

/*
**
**	 Statics
**
*/

#ifdef _WIN32

HINSTANCE hInstance          = NULL;
HWND      hMainWnd           = NULL;
char8*    pszTitle           = "levelpreview";
char8*    pszMainClassName   = "Main";
#endif

/**/


/******************************************************************/
/* InitWindow                                                     */
/******************************************************************/

void* InitWindow( int32 Width, int32 Height )
 {
#ifdef _WIN32
  WNDCLASS MainWC;

  /* Register the application window class */

  MainWC.style         = CS_HREDRAW | CS_VREDRAW;
  MainWC.lpszClassName = pszMainClassName;
  MainWC.lpfnWndProc   = MainWndProcCallback;
  MainWC.cbClsExtra    = 0;
  MainWC.cbWndExtra    = 0;
  MainWC.hInstance     = hInstance;
  MainWC.hIcon         = NULL;
  MainWC.hCursor       = LoadCursor(NULL, IDC_ARROW);
  MainWC.hbrBackground = (HBRUSH)GetStockObject(GRAY_BRUSH);
  MainWC.lpszMenuName  = NULL;
  
  if(!RegisterClass(&MainWC))
   { 
    return(NULL);
   }

  /* Create the application window */

  hMainWnd = CreateWindow(
               pszMainClassName,
               pszTitle,
               WS_OVERLAPPEDWINDOW |
               WS_CLIPCHILDREN |
               WS_CLIPSIBLINGS, /* Needed for OpenGL */
               CW_USEDEFAULT,
               CW_USEDEFAULT,
               //CW_USEDEFAULT,
               //CW_USEDEFAULT,
               Width,
               Height,
               NULL,
               NULL,
               GetModuleHandle( NULL ),
               (LPVOID)(NULL) );

  if(!hMainWnd)
   {
    return(NULL);
   }

  /* Set the application window's this pointer */

  SetWindowLong( (HWND)hMainWnd, GWL_USERDATA, (LONG)NULL );

  /* Show the application window */

  ShowWindow( (HWND)hMainWnd, TRUE );

  return(hMainWnd);
#else

  /* Bootstrap */
  
  pid_t pid;
  proc_spawn(&pid,"brio.elf",NULL,0, 200, 0);
  spu_initialize(6,6);

  return(NULL);
#endif
 }

/******************************************************************/
/* CloseWindow                                                    */
/******************************************************************/

int CloseWindow()
 {
#ifdef _WIN32
  DestroyWindow( hMainWnd );
#endif
  return(0);
 }

#ifdef _WIN32
/******************************************************************/
/* MainWndProcCallback                                            */
/******************************************************************/

LRESULT CALLBACK MainWndProcCallback(
                  HWND   hWnd,
                  UINT   uMsg,
                  WPARAM wParam,
                  LPARAM lParam )
 {
  return(DefWindowProc((HWND)hWnd, uMsg, wParam, lParam));
 }
#endif

/******************************************************************/
/* MessagePump                                                    */
/******************************************************************/

void MessagePump( void )
 {
#if defined( _WIN32 )
  MSG Message;
  BOOL havemsg = PeekMessage( & Message, hMainWnd, 0, 0, PM_REMOVE );
  while(havemsg)
   {
    TranslateMessage(&Message);
    DispatchMessage(&Message);
    havemsg = PeekMessage(&Message, hMainWnd, 0, 0, PM_REMOVE);
   }
#endif
 }

/* End of File */
