/******************************************************************

Module: TitanInputHandler.h

Author: 

Description:

TitanInputHandler class definition

Copyright 2005 Sony Online Entertainment.  All rights reserved.

*******************************************************************/

#ifndef __TITANINPUTHANDLER_H__
#define	__TITANINPUTHANDLER_H__

/*
**
**	 Forward Declarations
**
*/

class TitanUII;

/**/

/*
**
**	 Includes
**
*/

#include "TitanI.h"
#include "nameid.h"

/**/

class cGameObject;
class cAbilityMaster;
/*
**
**	 Type Definitions
**
*/
class TitanInputHandler : public TitanInputHandlerI
{
public:
  TitanInputHandler( TitanUII* titanUII );

  // handle controller button state changes
  virtual void OnButtonDown( TitanButton tb );
  virtual void OnButtonUp( TitanButton tb );
  virtual void OnPauseGame( );
  virtual void OnUnPauseGame( );

  void SetGameObject(cGameObject *newobj, int playerIndex);

  void Update(float time);

  cGameObject* GetGameObject() { return( mpObject ); }

  void MapAbility(TitanButton tb, const cAbilityMaster* pAbility);
  const cAbilityMaster* GetMappedAbility(TitanButton tb);

  void ToggleAbilityUnlock();

  void Reset();

private:
  int GetNextAbilityIndex(int index);
  int GetPrevAbilityIndex(int index);

  TitanUII*                mpTitanUI;
  cGameObject*             mpObject;
  int                      mPlayerIndex;
  TitanButton              mHeldSpellButton;
  float                    mSpellListTimer;                     
  int                      mSpellListIndex;
};

/**/

#endif // __TITANINPUTHANDLER_H__








