/********************************************************************

  Module: TitanT4OS

  Author: Carlo Ordonez

  Description:

    Platform-specific OS functions for T4

  Copyright 2005 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#include "TitanT4OS.h"
#include "SyPlatformMisc.h"
#include "SyNew.h"

//***********************************************************************
// Constructor
//***********************************************************************

TitanT4OS::TitanT4OS()
{
}

//***********************************************************************
// Destructor
//***********************************************************************

TitanT4OS::~TitanT4OS()
{
}

//***********************************************************************
// sleep
//***********************************************************************

void TitanT4OS::sleep( unsigned int milliseconds )
{
  SyPlatform::Sleep( milliseconds );
}

//***********************************************************************
// malloc
//***********************************************************************

void* TitanT4OS::malloc( size_t size )
{
  return( SyMalloc( size ) );
}

//***********************************************************************
// free
//***********************************************************************

void TitanT4OS::free( void* pBuffer )
{
  SyFree( pBuffer );
}
