/******************************************************************
  
  Module:  ailodmanager.h
  
  Author: Borut Pfeifer
  
  Description: varies update rate for NPCs based on distance to camera

  
  Copyright 2006 Sony Online Entertainment.  All rights reserved.
  
*******************************************************************/

#ifndef AILODMANAGER_H
#define AILODMANAGER_H

#include <vector>

class cGameObject;
class Titan;
class cAi;


class cAILODManager
{
public:
  static void AddNPC(cGameObject* pNPC, bool bAlwaysUpdate = false);
  static void RemoveNPC(cGameObject* pNPC);
  static void Update(Titan* pTitan, float time);

  static void DisableAll(bool bDisable);

protected:

  struct NPCEntry
  {
    NPCEntry();

    cAi*  mpAI;
    int   mNPCID;
    float mDistSqr;
    float mFindTargetTime;
    bool  mbAlwaysUpdate;
    static bool CompareDist(const NPCEntry& entry1, const NPCEntry& entry2) { return entry1.mDistSqr < entry2.mDistSqr; }
    static bool CompareFindTargetTime(const NPCEntry& entry1, const NPCEntry& entry2) { return entry1.mDistSqr < entry2.mDistSqr; }
  };

  typedef std::vector<NPCEntry> NPCVector;
  static NPCVector smNPCs;
  static bool smbDisabled;
};


#endif
