/******************************************************************
  
  Module:  lostable.h
  
  Author: Borut Pfeifer
  
  Description: Manages line of sight info for all the different
               NPCs, and queues up requests for ray casts

  
  Copyright 2005 Sony Online Entertainment.  All rights reserved.
  
*******************************************************************/

#ifndef LOSTABLE_H
#define LOSTABLE_H

//-------------------------------------------------------- Includes
#include "SySceneFilter.h"
#include "SyVect3.h"
//-------------------------------------------------------- Typedefs
//---------------------------------------------- Class Declarations

class SyScene;
class cGameObjectRegistry;

class cLOSTable
{
public:
  enum LOSStatus
  {
    LOS_INVALID = 0,
    LOS_BLOCKED,
    LOS_CLEAR,
    LOS_PENDING
  };

  // Schedules a ray cast to be done later, use the ticket value to check results
  static LOSStatus RequestLOS(const SyVect3& sourcePos,
                              const SyVect3& targetPos,
                              bool bTestAreaEffects,
                              int& ticket,
                              float radius = 0.0f);
  
  // Cancel a scheduled ray cast 
  static void CancelLOS(int ticket);

  // Test if a ticket (returned via RequestLOS) is done
  static LOSStatus HasLOS(int ticket, 
                          SyVect3* pHitPos = NULL,
                          SyVect3* pHitNormal = NULL);


  // Perform our allotment of ray casts per frame
  static void Update(cGameObjectRegistry* pRegistry, SyScene* pScene);


protected:
  enum Constants
  {
    MAX_LOS_PER_FRAME = 4,
    MAX_LOS_ENTRIES = 128
  };

  struct LOSEntry
  {
    LOSEntry();
    SyVect3 mSourcePos;
    SyVect3 mTargetPos;
    SyVect3 mHitPos;
    SyVect3 mHitNormal;
    uint64 mRequestTime;
    float mRadius;
    int mUsedCount;
    LOSStatus mStatus;
    bool mbTestAreaEffects;
  };

  static LOSEntry smEntries[MAX_LOS_ENTRIES];
};


class cLOSSceneFilter : public SySceneFilter
{
public: 
  cLOSSceneFilter(cGameObjectRegistry* pRegistry);

  virtual int FilterActor( SyScene& Scene, SyActorHandle ActorHandle );

protected:
  cGameObjectRegistry* mpRegistry;
};
//------------------------------------------- Function Declarations
//--------------------------------------------------------- Globals
//------------------------------------------------ Inline Functions

#endif
