/******************************************************************
  
  Module:  animdefs.h
  
  Author: Sean Craig
  
  Description:  Containes enum for anim id's defined in the 
  biped.ccf config file in the character tool directory

  
  Copyright 2005 Sony Online Entertainment.  All rights reserved.
  
*******************************************************************/

#ifndef ANIMDEFS_H
#define ANIMDEFS_H

//-------------------------------------------------------- Includes
//-------------------------------------------------------- Typedefs
//---------------------------------------------- Class Declarations
typedef enum 
{
  ANIM_B_STAND_IDLE=1,
  ANIM_B_STAND_IDLE_BREAK_01=2,
  ANIM_B_MOVE_F_WALK,
  ANIM_B_MOVE_F_RUN, // from Brad's mapping
  ANIM_B_DEATH = 6,
  ANIM_B_IMPACT_FRONT,
  ANIM_B_IMPACT_BACK,
  ANIM_B_IMPACT_FWD_EXTREME,
  ANIM_B_JUMP = 11,
  ANIM_B_IN_AIR,
  ANIM_B_LAND,
  ANIM_B_FALLING ,
  ANIM_B_LAND_HARD,
  ANIM_B_BLOCK,
  ANIM_B_KNOCKBACK,
  ANIM_B_KNOCKBACK_IN_AIR = 19,
  ANIM_B_KNOCKBACK_LAND,
  ANIM_B_KNOCKBACK_GETUP,

  ANIM_B_KNOCKFORWARD,
  ANIM_B_KNOCKFORWARD_IN_AIR,
  ANIM_B_KNOCKFORWARD_LAND,
  ANIM_B_KNOCKFORWARD_GETUP,

  ANIM_B_TURN_90_L =26,
  ANIM_B_TURN_90_R,
  ANIM_B_TURN_180_L,

  ANIM_B_DODGE_F,
  ANIM_B_DODGE_B,
  ANIM_B_DODGE_L,
  ANIM_B_DODGE_R,

  ANIM_B_CAST_A,
  ANIM_B_CAST_B,
  
  ANIM_B_RUN_JUMP =35,
  ANIM_B_RUN_IN_AIR,
  ANIM_B_RUN_LAND,

  ANIM_B_BLOCK_FWD_TAKEDAM,
  ANIM_B_DODGE_FWD_TAKEDAM,

  ANIM_B_COMBAT_IDLE,
  ANIM_B_COMBAT_IDLE_BREAK_01,
  ANIM_B_TURN_180_R,
  ANIM_B_RUN_JUMP_R,
  ANIM_B_STAND_TAKEDAM_LEFT,
  ANIM_B_STAND_TAKEDAM_RIGHT,
  ANIM_B_EMOTE_ANGER,
  ANIM_B_COMBAT_IDLE_BREAK_02,
  ANIM_B_COMBAT_IDLE_BREAK_03,
  ANIM_B_STAND_IDLE_BREAK_02,
  ANIM_B_STAND_IDLE_BREAK_03,
  ANIM_B_CAST_C,
  ANIM_B_PULL_LEVER,
  ANIM_B_PUSH_LEVER,
  ANIM_B_STAND_STUNNED,
  ANIM_B_CAST_LOOP,
  ANIM_B_STAND_TAKEDAM_FWD_REPEAT,
  ANIM_B_STAND_TAKEDAM_BACK_REPEAT,
  ANIM_B_CAST_D,
  ANIM_B_STAND_TAKEDAM_FWD2,
  ANIM_B_STAND_TAKEDAM_FWD3,
  ANIM_B_STAND_TAKEDAM_FWD4,
  ANIM_B_STAND_TAKEDAM_FWD5,
  ANIM_B_STAND_TAKEDAM_FWD6,
  ANIM_B_COMBAT_IDLE_TO_STAND,
  ANIM_B_STAND_TAKEDAM_BCK2,
  ANIM_B_KNOCKBACK_DEATH,
  ANIM_B_KNOCKFOWARD_DEATH,
  ANIM_B_KNOCKBACK_IN_AIR2,
  ANIM_B_KNOCKFORWARD_IN_AIR2,

  ANIM_ATTACK_L = 103,
  ANIM_ATTACK_H,

  ANIM_ATTACK_LL = 106,
  ANIM_ATTACK_LH,
  ANIM_ATTACK_HL,
  ANIM_ATTACK_HH,
  ANIM_ATTACK_LLL,
  ANIM_ATTACK_LLH,
  ANIM_ATTACK_LHL,
  ANIM_ATTACK_LHH,
  ANIM_ATTACK_HLL,
  ANIM_ATTACK_HLH,
  ANIM_ATTACK_HHL,
  ANIM_ATTACK_HHH,

  ANIM_ATTACK_JUMP,
  ANIM_ATTACK_JUMP_LAND,

  ANIM_RANGED_ATTACK = 200,
  ANIM_RANGED_ATTACK_JUMP,

  ANIM_PICKUP_PROP,
  ANIM_STAND_HOLD_PROP,
  ANIM_WALK_HOLD_PROP,
  ANIM_THROW_PROP,
  ANIM_PUTDOWN_PROP,
  ANIM_HOLD_PROP_TAKEDMG_FWD,
  ANIM_HOLD_PROP_TAKEDMG_BACK,
  ANIM_HOLD_PROP_TAKEDMG_LEFT,
  ANIM_HOLD_PROP_TAKEDMG_RIGHT,
  ANIM_THROW_CHARACTER,
  ANIM_THROWN_BY_CHARACTER,
  ANIM_RUN_HOLD_PROP,
  ANIM_PUSH_PROP_FWD,
  ANIM_PUSH_PROP_LEFT,
  ANIM_PUSH_PROP_RIGHT,
  ANIM_PULL_PROP_BACK,
  ANIM_RELEASE_PROP,
  ANIM_GRAB_PROP,
  ANIM_PUSH_PROP_FWDRIGHT,
  ANIM_PUSH_PROP_FWDLEFT,
  ANIM_PULL_PROP_BACKRIGHT,
  ANIM_PULL_PROP_BACKLEFT,
  ANIM_WALK_SLAVE,
  ANIM_COWER,
  ANIM_WALK_BACKPEDAL,
  ANIM_WALK_STRAFE_RIGHT,
  ANIM_WALK_STRAFE_LEFT,
  ANIM_SUMMONED,
  ANIM_ATTACK_LLLL,

  ANIM_OVERRIDE = 500

}  tAnimIDValues;

typedef enum __eComboType
{
  COMBO_L, 
  COMBO_H,  
  COMBO_LL,  
  COMBO_LH,   
  COMBO_HL,
  COMBO_HH,

  COMBO_LLL,  
  COMBO_LLH,
  COMBO_LHL,
  COMBO_LHH,
  COMBO_HLL,
  COMBO_HLH,
  COMBO_HHL,
  COMBO_HHH,
  COMBO_LLLL,  

  COMBO_RANGEDATTACK,
  COMBO_JUMPATTACK,
  COMBO_THROWCHARACTER,
  NUM_COMBOS
} eComboType;

typedef enum __eCharacterIdentNode
{
  CHAR_NODE_HEAD = 1,
  CHAR_NODE_CHEST,
  CHAR_NODE_LEFT_FOOT,
  CHAR_NODE_RIGHT_FOOT,
  CHAR_NODE_LEFT_HAND,
  CHAR_NODE_RIGHT_HAND,
  CHAR_NODE_LEFT_SHOULDER,
  CHAR_NODE_RIGHT_SHOULDER,
  CHAR_NODE_RIGHT_HAND_CARRY,
  CHAR_NODE_LEFT_HAND_CARRY,
  CHAR_NODE_WAIST,
  CHAR_NODE_RIGHT_KNEE,
  CHAR_NODE_LEFT_KNEE,
  CHAR_NODE_RIGHT_ELBOW,
  CHAR_NODE_LEFT_ELBOW,
  CHAR_NODE_RIGHT_EYE,
  CHAR_NODE_LEFT_EYE,
  CHAR_NODE_MOUTH,
  CHAR_NODE_PROJECTILE_ATTACH_LOW1,
  CHAR_NODE_PROJECTILE_ATTACH_LOW2,
  CHAR_NODE_PROJECTILE_ATTACH_LOW3,
  CHAR_NODE_PROJECTILE_ATTACH_LOW4,
  CHAR_NODE_PROJECTILE_ATTACH_HIGH1,
  CHAR_NODE_PROJECTILE_ATTACH_HIGH2,
  CHAR_NODE_PROJECTILE_ATTACH_HIGH3,
  CHAR_NODE_PROJECTILE_ATTACH_HIGH4,
  CHAR_NODE_PROJECTILE_ATTACH_HIGH5,
  CHAR_NODE_PROJECTILE_ATTACH_HIGH6
} eCharacterIdentNode;

typedef enum
{
  CHAR_ATTACH_MELEE=1,
  CHAR_ATTACH_RANGED,
  CHAR_ATTACH_HEAD,
  CHAR_ATTACH_BODY,
  CHAR_ATTACH_FEET,
  CHAR_ATTACH_ACCESSORY,
  CHAR_ATTACH_SHIELD,
  CHAR_ATTACH_MAX_SLOTS
} eCharacterAttachSlots;

//------------------------------------------- Function Declarations
//--------------------------------------------------------- Globals
//------------------------------------------------ Inline Functions

#endif
