/******************************************************************
  
  Module:  database.h
  
  Author: Sean Craig
  
  Description: All of the xml database code, globbed into one place! 

  
  Copyright 2005 Sony Online Entertainment.  All rights reserved.
  
*******************************************************************/

#ifndef DATABASE_H
#define DATABASE_H

//-------------------------------------------------------- Includes
#include "nameid.h"
#include "SyMap.h"
#include "SyVector.h"
//-------------------------------------------------------- Typedefs
//---------------------------------------------- Class Declarations

class Titan;
class cStatsCharacterMaster;
class cStatsItemMaster;
class cStatsEnhancementMaster;
class cStatsProjectileMaster;
class cStatsPropMaster;
class cCharacterClass;
class cCharacterLevel;
class cStatsBlockBehavior;
class cStatsAbilitySet;
class cStatsModelData;
class cStatsMerchantSet;
class cStatsEnhancementComboModel;

class cTreasureSet;
class cMinimap;
class cDropList;
class cDebrisMaster;
class cExperienceTable;
class cDifficultySettingsTable;
class cSpellMaster;
class cAbilityMaster;
class cImpactFXSet;
class cImpactSoundSet;

class TiXmlNode;

class cDatabaseSys
{
public:
  typedef SyVector<cAbilityMaster *> AbilityVector;

  cDatabaseSys(Titan *titan);
  ~cDatabaseSys();

  void                          Init();

  void                          LoadDebrisModels(tGameID debrisMasterID);
  void                          LoadSpells();
  void                          LoadBlockBehaviors();
  void                          LoadAbilitySets();
  void                          LoadImpactFXSets();
  void                          LoadImpactSoundSets();
  void                          LoadModelData();

  const cStatsCharacterMaster   *GetCharacterMaster(tGameID id);
  const cStatsItemMaster        *GetItemMaster(tGameID id);
  const cStatsEnhancementMaster *GetEnhancementMaster(tGameID id); 
  const cStatsMerchantSet       *GetMerchantSet(tGameID id); 
  const cStatsProjectileMaster  *GetProjectileMaster(tGameID id);
  const cStatsPropMaster        *GetPropMaster(tGameID id);
  const cCharacterClass         *GetCharacterClass(tGameID id);
  const cCharacterLevel         *GetCharacterLevel(int level);
  
        cTreasureSet            *GetTreasureSet(tGameID id) const;
        cMinimap                *GetMinimap(tGameID id) const;
        cTreasureSet            *GetDefaultTreasureSetForLevel(tGameID levelID) const;
        cDropList               *GetDropList(tGameID id);
  const cDebrisMaster           *GetDebrisMaster(tGameID id);
  const cExperienceTable        *GetExperienceTable();
  const cDifficultySettingsTable *GetDifficultySettingsTable();
  const cSpellMaster            *GetSpellMaster(tGameID id);         
  const cAbilityMaster          *GetAbilityMaster(tGameID id, int rank); 
  const cStatsBlockBehavior     *GetBlockBehavior(tGameID id);
  const cStatsAbilitySet        *GetAbilitySet(tGameID id);
  const cImpactFXSet            *GetImpactFXSet(tGameID id);
  const cImpactSoundSet            *GetImpactSoundSet(tGameID id);
  const cStatsModelData         *GetModelData(tGameID id);

  const SyMap<tGameID,cStatsCharacterMaster*>& GetCharacterMap() { return mCharacterMasters; }
  const SyMap<tGameID,cStatsItemMaster*>&      GetItemMap() { return mItemMasters; }
  const SyMap<tGameID,cStatsPropMaster*>&      GetPropMap() { return mPropMasters; }
  const SyMap<tGameID, AbilityVector>&         GetAbilityMap() { return mAbilityMasters; } 
  const AbilityVector&                         GetCompleteAbilityList() { return mUnlockAbilityList; } 
  const SyVector<cStatsEnhancementComboModel*>& GetEnhancementComboModels() { return mEnhancementComboModels; } 


  uint32                         GetTextID(tGameID id); // goes from string hash id to text index

private:

  void                         LoadCharacterMasters();
  void                         LoadItemMasters();
  void                         LoadProjectileMasters();
  void                         LoadPropMasters();
  void                         LoadClasses();
  void                         LoadLevels();
  void                         LoadDropLists();
  void                         LoadTreasureSets();
  void                         LoadDebris();
  void                         LoadExperienceTable();
  void                         LoadDifficultySettingsTable();
  void                         LoadAbilities();
  void                         LoadEnhancements();
  void                         LoadMerchantSets();
  void                         LoadEnhancementComboModels();
  void                         LoadTextIDs();
  void                         LoadZones();
  void                         LoadMinimapInfo(tGameID levelID, TiXmlNode* node);

  SyMap<tGameID,cStatsCharacterMaster *>   mCharacterMasters;
  SyMap<tGameID,cStatsItemMaster *>        mItemMasters;
  SyMap<tGameID,cStatsEnhancementMaster *> mEnhancementMasters;
  SyMap<tGameID,cStatsProjectileMaster *>  mProjectileMasters;
  SyMap<tGameID,cStatsPropMaster *>        mPropMasters;
  SyMap<tGameID,cCharacterClass *>         mCharacterClasses; 
  SyMap<int,cCharacterLevel *>             mLevelMasters; 
  SyMap< tGameID, cTreasureSet* >          mTreasureSets;
  SyMap< tGameID, cMinimap* >              mMiniMaps;
  SyMap<int,cDropList *>                   mDropLists;
  SyMap<int,cDebrisMaster *>               mDebrisMasters;
  cExperienceTable*                        mpExperienceTable;
  cDifficultySettingsTable*                mpDifficultySettingsTable;
  SyMap<tGameID,cSpellMaster *>            mSpellMasters;
  SyMap<tGameID, AbilityVector>            mAbilityMasters;
  AbilityVector                            mUnlockAbilityList;
  SyMap<tGameID, cStatsBlockBehavior*>     mBlockBehaviors;
  SyMap<tGameID, cStatsAbilitySet*>        mAbilitySets;
  SyMap<tGameID, cImpactFXSet*>            mImpactFXSets;
  SyMap<tGameID, cImpactSoundSet*>         mImpactSoundSets;
  SyMap<tGameID, cStatsModelData*>         mModelData;
  SyMap<tGameID, cStatsMerchantSet*>       mMerchantSets;
  SyVector<cStatsEnhancementComboModel*>   mEnhancementComboModels; 

  SyMap<tGameID, uint32>                   mTextIDs;
  SyMap< tGameID, tGameID >                mZoneDefaultTreasureSets;

  Titan *                       mpTitan;
};

//------------------------------------------- Function Declarations
bool ChooseEnum(const char *str,const char **name_list,int name_list_size, int& retVal);
//--------------------------------------------------------- Globals
//------------------------------------------------ Inline Functions

#endif
