/******************************************************************
  
  Module:  droplist.h
  
  Author: Sean Craig
  
  Description: A system for the designers to specify which items
  get produced when a monster gets killed or a barrel gets broken. 

  
  Copyright 2005 Sony Online Entertainment.  All rights reserved.
  
*******************************************************************/

#ifndef DROPLIST_H
#define DROPLIST_H

//-------------------------------------------------------- Includes
#include "titan.h"
#include "SyVect3.h"
#include "nameid.h"
#include "SyVector.h"
//-------------------------------------------------------- Typedefs
//---------------------------------------------- Class Declarations

class cDropListElement
{
public:
  typedef enum 
  {
    DROP_ITEM,
    DROP_LIST,
    DROP_HEALTH,
    DROP_MANA,
    DROP_ESSENCE,
  } eDropType;

  cDropListElement();
  ~cDropListElement();

  bool                        Drop(cGameObject* pOwner, SyVect3 location);

  eDropType                   mType;
  tGameID                     mDropID; // item or drop list id
  int                         mWeight;
  int                         mMinAmount;
  int                         mMaxAmount;
};

class cDropList 
{
public:
  cDropList();
  ~cDropList();

  void                        Drop(cGameObject* pOwner, SyVect3 location);

  static void                 DropHealth(cGameObject* pOwner, const SyVect3& location, int amt, tGameID projID);
  static void                 DropMana(cGameObject* pOwner, const SyVect3& location, int amt, tGameID projID);
  static void                 DropEssence(cGameObject* pOwner, const SyVect3& location, int amt, tGameID projID);

  cNameID                     mName;
  SyVector<cDropListElement>  mElements;

  static void RegisterTuningVariables();
  protected:
    static float smDropLingerTime;
};

class cTreasureSetElement
{
public:
  cTreasureSetElement();
  ~cTreasureSetElement();

  void                        Drop(cGameObject* pOwner, SyVect3 location);

  tGameID                     mDropID;  // drop list id
  float                       mChance;
};


class cTreasureSet
{
public:
  cTreasureSet();
  ~cTreasureSet();

  void                        Drop(cGameObject* pOwner, SyVect3 location, cGameObject* pActivater);

  cNameID                     mName;
  SyVector<cTreasureSetElement>  mElements;
};




//------------------------------------------- Function Declarations
class TiXmlNode;
class cDatabaseSys;
cDropList *   ParseDropList(cDatabaseSys *db,TiXmlNode* node);
cTreasureSet *ParseTreasureSet(cDatabaseSys *db, TiXmlNode* node);
//--------------------------------------------------------- Globals
//------------------------------------------------ Inline Functions

#endif
