/******************************************************************
  
  Module:  nameid.cpp
  
  Author: Sean Craig
  
  Copyright 2005 Sony Online Entertainment.  All rights reserved.
  
*******************************************************************/

//-------------------------------------------------------- Includes

#include "nameid.h"
#include "SyResourceID.h"
#include <stddef.h>
#include <string.h>

//---------------------------------------------- Class Declarations
//--------------------------------------------------------- Globals
//----------------------------------------- Functions Declarations
//------------------------------------ Member Functions Definitions
//------------------------------------------------ cNameID


cNameID::cNameID(const char *name) : mName(NULL),mID(0)
{
  if (name != NULL)
  {
    SetName(name);
  }
}

cNameID::~cNameID()
{
  delete mName;
}

void
cNameID::SetName(const char *name)
{
  delete mName;
  mName = new char[strlen(name)+1];
  strcpy(mName,name);
  mID= SyHashResourceID( mName );
}


// EOF
