/******************************************************************
  
  Module:  nameid.h
  
  Author: Sean Craig
  
  Description: Support for generic universal ids generated from 
  strings. 

  
  Copyright 2005 Sony Online Entertainment.  All rights reserved.
  
*******************************************************************/

#ifndef NAMEID_H
#define NAMEID_H

//-------------------------------------------------------- Includes
#include "SyResourceID.h"
#include <stddef.h>
//-------------------------------------------------------- Typedefs

typedef int tGameID;
static const tGameID ID_NONE = (0);
//---------------------------------------------- Class Declarations

class cNameID
{
public:
              cNameID(const char *name=NULL);
              ~cNameID();

  const char *GetName() const {return mName;};
  tGameID     GetID() const {return mID;};
  void        SetName(const char *name);

  char        *mName;
  tGameID     mID;
};

//------------------------------------------- Function Declarations
//--------------------------------------------------------- Globals
//------------------------------------------------ Inline Functions


#endif
