/******************************************************************
  
  Module:  quest.cpp
  
  Author: Sean Craig
  
  Copyright 2005 Sony Online Entertainment.  All rights reserved.
  
*******************************************************************/

//-------------------------------------------------------- Includes
#include "quest.h"
//---------------------------------------------- Class Declarations
//----------------------------------------- Functions Declarations
//------------------------------------ Member Functions Definitions

cQuestSys::cQuestSys()
{
  InitPropObject( QUESTSYS_CLASSID );
};

cQuestSys::~cQuestSys()
{
}

int           
cQuestSys::InitPropClass()
{
 SyPropClassID ClassID = QUESTSYS_CLASSID;
/* Add the class */

  AddClass( ClassID, 
           "cQuestSys", 
            Creator, 
            ClassID, 
            0 ); 

  AddSimpleMapProperty<tQuestID,int>(ClassID,
                                           0x0000,
                                           SyMemberOffset(cQuestSys,mValues),
                                           "mValues",
                                           SYPROPTYPE_INT32,
                                           SYPROPTYPE_INT32);
  return 0;
}


SyPropObject* 
cQuestSys::Creator()
{
 SyPropObject *pObject;

  pObject = SyNew cQuestSys();
  if (pObject == NULL)
  {
    SyAssert(0);
    return(NULL);
  }

  return(pObject);
}

int32       
cQuestSys::get(tQuestID id)
{
  int index = mValues.Find(id); 

  if (index == mValues.End())
  {
    return 0;
  };

  return mValues(index);
}

void      
cQuestSys::set(tQuestID id, int32 value)
{
  int index = mValues.Find(id); 

  if (index == mValues.End())
  {
    mValues.Insert(id,value);
    return;
  };

  mValues(index) = value;
}


//------------------------------------ Functions Definitions


// EOF
