/******************************************************************
  
  Module:  soundmanager.h
  
  Author: Borut Pfeifer
  
  Description: Crappy singleton to throw sound actors in SYScene and remove them
               I wish we had a sound programmer. Oh, wait, I wish we had more 
               than one gameplay programmer

  
  Copyright 2005 Sony Online Entertainment.  All rights reserved.
  
*******************************************************************/

#ifndef SOUNDMANAGER_H
#define SOUNDMANAGER_H

//-------------------------------------------------------- Includes
//-------------------------------------------------------- Typedefs
//---------------------------------------------- Class Declarations

#include "SySceneTypes.h"
#include "SyList.h"
#include "netpacket.h"

class Titan;
class SyVect3;


class cSoundManager
{
public:
  cSoundManager();
  ~cSoundManager();

  bool Init(Titan* pTitan);

  void Update(float time);

  bool Play(tGameObjectID objID, const char* soundFileName, int priority);
  bool Play3D(tGameObjectID objID, const char* soundFileName, int priority, const SyVect3& loc, float minRadius);
  bool PlayImpact(int32 resourceHandle, const SyVect3& loc);

  void Stop(tGameObjectID objID);

  void StopAll();

private:
  Titan* mpTitan;

  struct SoundInfo
  {
    tGameObjectID mObjID;
    SyActorHandle mActorHandle;
    int32 mPlaybackHandle;
    int32 mAssetHandle;
    float mLifetime;
  };

  SyList<SoundInfo> mSounds;
};

#endif
