/******************************************************************
  
  Module:  transient.h
  
  Author: Sean Craig
  
  Description:  A transient is a value that changes over time, 
  like a dampened spring.  I've also seen them called "motion controllers".

  
  Copyright 2005 Sony Online Entertainment.  All rights reserved.
  
*******************************************************************/

#ifndef TRANSIENT_H
#define TRANSIENT_H

//-------------------------------------------------------- Includes
//-------------------------------------------------------- Typedefs
//---------------------------------------------- Class Declarations
// class for smoothly transitioning a variable over time
class cTransient 
{
public:
  cTransient();
  ~cTransient(){};

  float GetValue(){return mValue;};
  void  SetValue(float value){mValue = value;};

  void  SetTarget(float target){mTarget = target;mTargetSet = true;};
  float GetTarget(){return mTarget ;};
  void  ClearTarget(){mTargetSet = false;};

  void  SetVelocity(float vel){mVelocity = vel;};
  float GetVelocity(){return mVelocity;};
  void  SetConstants(float maxVelocity, float acceleration)
  {
    mMaxVelocity = maxVelocity;
    mAcceleration = acceleration;
  };

  void  Push(float amount,float maxVel);
  void  Update(float time);

protected:
  void  _CheckCloseEnough(float time);


  float     mValue;

  bool      mTargetSet;
  float     mTarget;
  float     mVelocity;

  float     mMaxVelocity;
  float     mAcceleration;
  bool      mPushed;

};


class cTransientAngle
{
public:
  cTransientAngle();
  ~cTransientAngle(){};

  float GetValue(){return mValue;};
  void  SetValue(float value);

  void  SetTarget(float target);
  float GetTarget(){return mTarget ;};
  void  ClearTarget(){mTargetSet = false;};

  void  SetVelocity(float vel){mVelocity = vel;};
  float GetVelocity(){return mVelocity;};
  void  SetConstants(float maxVelocity, float acceleration)
  {
    mMaxVelocity = maxVelocity;
    mAcceleration = acceleration;
  };

  void  Push(float amount,float maxvel);
  void  Update(float time);

protected:
  void  _CheckCloseEnough(float time);

  float     mValue;

  bool      mTargetSet;
  float     mTarget;
  float     mVelocity;

  float     mMaxVelocity;
  float     mAcceleration;
  bool      mPushed;

};

//------------------------------------------- Function Declarations
//--------------------------------------------------------- Globals
//------------------------------------------------ Inline Functions

#endif
