/********************************************************************

  Module: TiAppearanceWindow

  Author: Carlo Ordonez

  Description:

    Panel for changing your appearance

  Copyright 2005 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#ifndef _TiAppearanceWindow_h_
#define _TiAppearanceWindow_h_

#include "TiWindow.h"

#define ID_WINDOW_APPEARANCE        (wxID_HIGHEST + 0x0f00)

class TiAppearanceWindow : public TiWindow
{
public:
  TiAppearanceWindow( wxWindow* pParent, TitanI* pTitan, int PlayerId, const wxString& Name = _("Change Appearance"), int WindowId = ID_WINDOW_APPEARANCE );
  ~TiAppearanceWindow();

private:

  void        OnKeyDown( wxKeyEvent& event );
  void        OnSize( wxSizeEvent& event );

private:

  enum Mode
  {
    kSkin = 0,
    kHairStyle,
    kHairColor,
    kFacialHair,
    kMax
  };

  int             mSelection;
  wxStaticText*   mpTitle;

  DECLARE_CLASS( TiAppearanceWindow )
  DECLARE_EVENT_TABLE()
};

#endif

