/********************************************************************

Module: TiBPCommandHandler

Author: Jon Wiesman (for Borut)

Description:

This class registers itself as a command handler with an ID.  
Whenever anyone types a string into the command console with that ID prepended,
the console window passes that string to this class for processing.

Copyright 2005 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#include "TiBPCommandHandler.h"
#include "script_func.h"
#include "script_pawn.h"
#include "netpacket.h"
#include "gameerror.h"
#include "script_pawn.h"


static TiBPCommandHandler s_myHandler;

TiBPCommandHandler::TiBPCommandHandler() : TiConsoleCommandHandler()
{
}

void TiBPCommandHandler::ProcessConsoleCommand(const SyString &str)
{
  if (str.Length() > 0 &&
      (str.AsChar()[0] == '/' || str.AsChar()[0] == '\\'))
  {
    SyString command;
    command.Init(str, 1, str.Length()-1);
    cScriptSys::ProcessScriptFunction(command);
  }
}
